/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.utilities;

import com.google.common.base.Stopwatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimedBlock
implements AutoCloseable {
    private static final Logger ownLogger = LoggerFactory.getLogger(TimedBlock.class);
    private final Stopwatch stopwatch = Stopwatch.createUnstarted();
    private final Logger log;
    private final String name;
    private final long threshold;
    private final TimeUnit thresholdUnit;
    private final TimeUnit reportUnit;

    private TimedBlock(Logger log, String name, long threshold, TimeUnit thresholdUnit, TimeUnit reportUnit) {
        this.log = log;
        this.name = name;
        this.threshold = threshold;
        this.thresholdUnit = thresholdUnit;
        this.reportUnit = reportUnit;
    }

    public static Builder timed(String name) {
        return new Builder(name);
    }

    public TimedBlock start() {
        this.stopwatch.start();
        return this;
    }

    @Override
    public void close() {
        this.stopwatch.stop();
        if (this.stopwatch.elapsed(this.thresholdUnit) >= this.threshold) {
            this.log.info("[{}] execution took {} {}", new Object[]{this.name, this.stopwatch.elapsed(this.reportUnit), this.niceName(this.reportUnit)});
        }
    }

    private String niceName(TimeUnit reportUnit) {
        switch (reportUnit) {
            case NANOSECONDS: {
                return "ns";
            }
            case MICROSECONDS: {
                return "\u00b5s";
            }
            case MILLISECONDS: {
                return "ms";
            }
            case SECONDS: {
                return "s";
            }
            case MINUTES: {
                return "m";
            }
            case HOURS: {
                return "h";
            }
            case DAYS: {
                return "d";
            }
        }
        return "";
    }

    public static class Builder {
        private Logger log = ownLogger;
        private String name = "block";
        private long threshold = 0L;
        private TimeUnit thresholdUnit = TimeUnit.MILLISECONDS;
        private TimeUnit reportUnit = TimeUnit.MILLISECONDS;

        public Builder(String name) {
            this.name(name);
        }

        public Builder log(Logger log) {
            this.log = log;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder aboveMillis(long time) {
            this.threshold = time;
            return this;
        }

        public Builder above(long time, TimeUnit unit) {
            this.threshold = time;
            this.thresholdUnit = unit;
            return this;
        }

        public Builder millis() {
            this.reportTimeUnit(TimeUnit.MILLISECONDS);
            return this;
        }

        public Builder micros() {
            this.reportTimeUnit(TimeUnit.MICROSECONDS);
            return this;
        }

        public Builder seconds() {
            this.reportTimeUnit(TimeUnit.SECONDS);
            return this;
        }

        public Builder reportTimeUnit(TimeUnit reportUnit) {
            this.reportUnit = reportUnit;
            return this;
        }

        public TimedBlock start() {
            return new TimedBlock(this.log, this.name, this.threshold, this.thresholdUnit, this.reportUnit).start();
        }
    }
}

