/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.utilities.date;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.graylog2.plugin.Tools;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public record MultiFormatDateParser(List<DateTimeFormatter> dateTimeFormatters) {
    private static final List<DateTimeFormatter> DEFAULT_DATE_TIME_FORMATTERS = ImmutableList.of((Object)Tools.ES_DATE_FORMAT_NO_MS_FORMATTER, (Object)Tools.ES_DATE_FORMAT_FORMATTER, (Object)ISODateTimeFormat.dateTimeParser().withOffsetParsed().withZoneUTC());

    public MultiFormatDateParser() {
        this(DEFAULT_DATE_TIME_FORMATTERS);
    }

    public DateTime parseDate(String value) {
        for (DateTimeFormatter formatter : this.dateTimeFormatters) {
            try {
                return formatter.parseDateTime(value);
            }
            catch (Exception exception) {
            }
        }
        throw new IllegalArgumentException("Unable to parse date: " + value);
    }
}

