/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.validation;

import java.nio.charset.StandardCharsets;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.graylog2.validation.SizeInBytes;

public class SizeInBytesValidator
implements ConstraintValidator<SizeInBytes, String> {
    private int min;
    private int max;

    public void initialize(SizeInBytes annotation) {
        this.min = annotation.min();
        this.max = annotation.max();
    }

    public boolean isValid(String object, ConstraintValidatorContext constraintContext) {
        if (object == null) {
            return true;
        }
        int lengthInBytes = object.getBytes(StandardCharsets.UTF_8).length;
        return lengthInBytes >= this.min && lengthInBytes <= this.max;
    }
}

