/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog.events.fields.providers.FieldValueProvider;
import org.graylog.events.processor.EventProcessor;
import org.graylog.events.processor.storage.EventStorageHandler;
import org.graylog.events.rest.AutoValue_AvailableEntityTypesResource_AvailableEntityTypesSummary;
import org.graylog.plugins.views.search.rest.SeriesDescription;
import org.graylog2.plugin.rest.PluginRestResource;
import org.graylog2.shared.rest.resources.RestResource;

@Api(value="Events/EntityTypes", description="Event entity types", tags={"cloud"})
@Path(value="/events/entity_types")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@RequiresAuthentication
public class AvailableEntityTypesResource
extends RestResource
implements PluginRestResource {
    private final Set<String> eventProcessorTypes;
    private final Set<String> fieldValueProviderTypes;
    private final Set<String> storageHandlerFactories;
    private final Set<String> aggregationFunctions;

    @Inject
    public AvailableEntityTypesResource(Map<String, EventProcessor.Factory> eventProcessorFactories, Map<String, FieldValueProvider.Factory> fieldValueProviders, Map<String, EventStorageHandler.Factory> storageHandlerFactories, Map<String, SeriesDescription> aggregationFunctions) {
        this.eventProcessorTypes = eventProcessorFactories.keySet();
        this.fieldValueProviderTypes = fieldValueProviders.keySet();
        this.storageHandlerFactories = storageHandlerFactories.keySet();
        this.aggregationFunctions = aggregationFunctions.keySet();
    }

    @GET
    @ApiOperation(value="List all available entity types")
    public AvailableEntityTypesSummary all() {
        return AvailableEntityTypesSummary.create(this.eventProcessorTypes, this.fieldValueProviderTypes, this.storageHandlerFactories, this.aggregationFunctions);
    }

    @JsonAutoDetect
    @AutoValue
    public static abstract class AvailableEntityTypesSummary {
        @JsonProperty(value="processor_types")
        public abstract Set<String> processorTypes();

        @JsonProperty(value="field_provider_types")
        public abstract Set<String> fieldProviderTypes();

        @JsonProperty(value="storage_handler_types")
        public abstract Set<String> storageHandlerTypes();

        @JsonProperty(value="aggregation_functions")
        public abstract Set<String> aggregationFunctions();

        public static AvailableEntityTypesSummary create(Set<String> processorTypes, Set<String> fieldProviderTypes, Set<String> storageHandlerTypes, Set<String> aggregationFunctions) {
            return new AutoValue_AvailableEntityTypesResource_AvailableEntityTypesSummary(processorTypes, fieldProviderTypes, storageHandlerTypes, aggregationFunctions);
        }
    }
}

