/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.integrations.aws;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.graylog.integrations.aws.AWSAuthFactory;
import org.graylog.integrations.aws.resources.requests.AWSRequest;
import org.graylog2.Configuration;
import org.graylog2.security.encryption.EncryptedValue;
import org.graylog2.security.encryption.EncryptedValueService;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsClient;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsClientBuilder;
import software.amazon.awssdk.services.iam.IamClient;
import software.amazon.awssdk.services.iam.IamClientBuilder;
import software.amazon.awssdk.services.kinesis.KinesisClient;
import software.amazon.awssdk.services.kinesis.KinesisClientBuilder;

public class AWSClientBuilderUtil {
    private final EncryptedValueService encryptedValueService;
    private final Configuration configuration;

    @Inject
    public AWSClientBuilderUtil(EncryptedValueService encryptedValueService, Configuration configuration) {
        this.encryptedValueService = encryptedValueService;
        this.configuration = configuration;
    }

    public AwsCredentialsProvider createCredentialsProvider(AWSRequest request) {
        return AWSAuthFactory.create(this.configuration.isCloud(), request.region(), request.awsAccessKeyId(), this.decryptSecretAccessKey(request.awsSecretAccessKey()), request.assumeRoleArn());
    }

    public void initializeBuilder(AwsClientBuilder builder, String endpoint, Region region, AwsCredentialsProvider credentialsProvider) {
        builder.region(region);
        builder.credentialsProvider(credentialsProvider);
        if (StringUtils.isNotEmpty((CharSequence)endpoint)) {
            builder.endpointOverride(URI.create(endpoint));
        }
    }

    public CloudWatchLogsClient buildClient(CloudWatchLogsClientBuilder clientBuilder, AWSRequest request) {
        Preconditions.checkNotNull((Object)request.region(), (Object)"An AWS region is required.");
        this.initializeBuilder((AwsClientBuilder)clientBuilder, request.cloudwatchEndpoint(), Region.of((String)request.region()), this.createCredentialsProvider(request));
        return (CloudWatchLogsClient)clientBuilder.build();
    }

    public KinesisClient buildClient(KinesisClientBuilder clientBuilder, AWSRequest request) {
        this.initializeBuilder((AwsClientBuilder)clientBuilder, request.kinesisEndpoint(), Region.of((String)request.region()), this.createCredentialsProvider(request));
        return (KinesisClient)clientBuilder.build();
    }

    public IamClient buildClient(IamClientBuilder clientBuilder, AWSRequest request) {
        Region iamRegion = Region.AWS_GLOBAL;
        if (request.region().contains("gov")) {
            iamRegion = Region.AWS_US_GOV_GLOBAL;
        }
        this.initializeBuilder((AwsClientBuilder)clientBuilder, request.iamEndpoint(), iamRegion, this.createCredentialsProvider(request));
        return (IamClient)clientBuilder.build();
    }

    private String decryptSecretAccessKey(EncryptedValue secretAccessKey) {
        return this.encryptedValueService.decrypt(Optional.ofNullable(secretAccessKey).orElse(EncryptedValue.createUnset()));
    }
}

