/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.integrations.notifications.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import java.net.URI;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.validation.constraints.NotBlank;
import org.graylog.events.contentpack.entities.EventNotificationConfigEntity;
import org.graylog.events.event.EventDto;
import org.graylog.events.notifications.EventNotificationConfig;
import org.graylog.events.notifications.EventNotificationExecutionJob;
import org.graylog.integrations.notifications.types.AutoValue_SlackEventNotificationConfig;
import org.graylog.integrations.notifications.types.SlackEventNotificationConfigEntity;
import org.graylog.scheduler.JobTriggerData;
import org.graylog2.contentpacks.EntityDescriptorIds;
import org.graylog2.contentpacks.model.entities.references.ValueReference;
import org.graylog2.plugin.rest.ValidationResult;
import org.joda.time.DateTimeZone;

@JsonTypeName(value="slack-notification-v1")
@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class SlackEventNotificationConfig
implements EventNotificationConfig {
    public static final String TYPE_NAME = "slack-notification-v1";
    private static final Pattern SLACK_PATTERN = Pattern.compile("https:\\/\\/hooks.slack.com\\/services\\/");
    private static final Pattern DISCORD_PATTERN = Pattern.compile("https:\\/\\/.*\\.?discord(app)?.com\\/api\\/webhooks.*\\/slack");
    private static final String DEFAULT_HEX_COLOR = "#ff0500";
    private static final String DEFAULT_CUSTOM_MESSAGE = "Graylog Slack Notification";
    private static final long DEFAULT_BACKLOG_SIZE = 0L;
    private static final DateTimeZone DEFAULT_TIME_ZONE = DateTimeZone.UTC;
    static final String INVALID_BACKLOG_ERROR_MESSAGE = "Backlog size cannot be less than zero";
    static final String INVALID_CHANNEL_ERROR_MESSAGE = "Channel cannot be empty";
    static final String INVALID_WEBHOOK_ERROR_MESSAGE = "Specified Webhook URL is not a valid URL";
    static final String INVALID_SLACK_URL_ERROR_MESSAGE = "Specified Webhook URL is not a valid Slack URL";
    static final String INVALID_DISCORD_URL_ERROR_MESSAGE = "Specified Webhook URL is not a valid Discord URL";
    static final String EMPTY_BODY_ERROR_MESSAGE = "If custom message is empty the title must be included";
    static final String INVALID_NOTIFY_SETTINGS = "Can only notify either @channel or @here, not both.";
    static final String WEB_HOOK_URL = "https://hooks.slack.com/services/xxx/xxxx/xxxxxxxxxxxxxxxxxxx";
    static final String CHANNEL = "#general";
    static final String FIELD_COLOR = "color";
    static final String FIELD_WEBHOOK_URL = "webhook_url";
    static final String FIELD_CHANNEL = "channel";
    static final String FIELD_CUSTOM_MESSAGE = "custom_message";
    static final String FIELD_USER_NAME = "user_name";
    static final String FIELD_NOTIFY_CHANNEL = "notify_channel";
    static final String FIELD_NOTIFY_HERE = "notify_here";
    static final String FIELD_LINK_NAMES = "link_names";
    static final String FIELD_ICON_URL = "icon_url";
    static final String FIELD_ICON_EMOJI = "icon_emoji";
    static final String FIELD_BACKLOG_SIZE = "backlog_size";
    static final String FIELD_TIME_ZONE = "time_zone";
    static final String FIELD_INCLUDE_TITLE = "include_title";

    @JsonProperty(value="backlog_size")
    public abstract long backlogSize();

    @JsonProperty(value="color")
    @NotBlank
    public abstract String color();

    @JsonProperty(value="webhook_url")
    @NotBlank
    public abstract String webhookUrl();

    @JsonProperty(value="channel")
    @NotBlank
    public abstract String channel();

    @JsonProperty(value="custom_message")
    public abstract String customMessage();

    @JsonProperty(value="user_name")
    @Nullable
    public abstract String userName();

    @JsonProperty(value="notify_channel")
    public abstract boolean notifyChannel();

    @JsonProperty(value="link_names")
    public abstract boolean linkNames();

    @JsonProperty(value="icon_url")
    @Nullable
    public abstract String iconUrl();

    @JsonProperty(value="icon_emoji")
    @Nullable
    public abstract String iconEmoji();

    @JsonProperty(value="time_zone")
    public abstract DateTimeZone timeZone();

    @JsonProperty(value="include_title")
    public abstract Boolean includeTitle();

    @JsonProperty(value="notify_here")
    public abstract Boolean notifyHere();

    @Override
    @JsonIgnore
    public JobTriggerData toJobTriggerData(EventDto dto) {
        return EventNotificationExecutionJob.Data.builder().eventDto(dto).build();
    }

    public static Builder builder() {
        return Builder.create();
    }

    @Override
    @JsonIgnore
    public ValidationResult validate() {
        ValidationResult validation = new ValidationResult();
        try {
            URI webhookUri = new URI(this.webhookUrl());
            if (webhookUri.getHost().toLowerCase(Locale.ROOT).contains("slack")) {
                if (!SLACK_PATTERN.matcher(this.webhookUrl()).find()) {
                    validation.addError(FIELD_WEBHOOK_URL, INVALID_SLACK_URL_ERROR_MESSAGE);
                }
            } else if (webhookUri.getHost().toLowerCase(Locale.ROOT).contains("discord") && !DISCORD_PATTERN.matcher(this.webhookUrl()).find()) {
                validation.addError(FIELD_WEBHOOK_URL, INVALID_DISCORD_URL_ERROR_MESSAGE);
            }
        }
        catch (Exception ex) {
            validation.addError(FIELD_WEBHOOK_URL, INVALID_WEBHOOK_ERROR_MESSAGE);
        }
        if (this.backlogSize() < 0L) {
            validation.addError(FIELD_BACKLOG_SIZE, INVALID_BACKLOG_ERROR_MESSAGE);
        }
        if (this.channel().isEmpty()) {
            validation.addError(FIELD_CHANNEL, INVALID_CHANNEL_ERROR_MESSAGE);
        }
        if (!this.includeTitle().booleanValue() && (this.customMessage() == null || this.customMessage().isBlank())) {
            validation.addError(FIELD_CUSTOM_MESSAGE, EMPTY_BODY_ERROR_MESSAGE);
            validation.addError(FIELD_INCLUDE_TITLE, EMPTY_BODY_ERROR_MESSAGE);
        }
        if (this.notifyChannel() && this.notifyHere().booleanValue()) {
            validation.addError(FIELD_NOTIFY_CHANNEL, INVALID_NOTIFY_SETTINGS);
            validation.addError(FIELD_NOTIFY_HERE, INVALID_NOTIFY_SETTINGS);
        }
        return validation;
    }

    @Override
    public EventNotificationConfigEntity toContentPackEntity(EntityDescriptorIds entityDescriptorIds) {
        return SlackEventNotificationConfigEntity.builder().color(ValueReference.of(this.color())).webhookUrl(ValueReference.of(this.webhookUrl())).channel(ValueReference.of(this.channel())).customMessage(ValueReference.of(this.customMessage())).userName(ValueReference.of(this.userName())).notifyChannel(ValueReference.of(this.notifyChannel())).linkNames(ValueReference.of(this.linkNames())).iconUrl(ValueReference.of(this.iconUrl())).iconEmoji(ValueReference.of(this.iconEmoji())).timeZone(ValueReference.of(this.timeZone().getID())).notifyHere(ValueReference.of(this.notifyHere())).build();
    }

    @AutoValue.Builder
    public static abstract class Builder
    implements EventNotificationConfig.Builder<Builder> {
        @JsonCreator
        public static Builder create() {
            return new AutoValue_SlackEventNotificationConfig.Builder().type(SlackEventNotificationConfig.TYPE_NAME).color(SlackEventNotificationConfig.DEFAULT_HEX_COLOR).webhookUrl(SlackEventNotificationConfig.WEB_HOOK_URL).channel(SlackEventNotificationConfig.CHANNEL).customMessage(SlackEventNotificationConfig.DEFAULT_CUSTOM_MESSAGE).notifyChannel(false).notifyHere(false).backlogSize(0L).linkNames(false).timeZone(DEFAULT_TIME_ZONE).includeTitle(true);
        }

        @JsonProperty(value="color")
        public abstract Builder color(String var1);

        @JsonProperty(value="webhook_url")
        public abstract Builder webhookUrl(String var1);

        @JsonProperty(value="channel")
        public abstract Builder channel(String var1);

        @JsonProperty(value="custom_message")
        public abstract Builder customMessage(String var1);

        @JsonProperty(value="user_name")
        public abstract Builder userName(String var1);

        @JsonProperty(value="notify_channel")
        public abstract Builder notifyChannel(boolean var1);

        @JsonProperty(value="link_names")
        public abstract Builder linkNames(boolean var1);

        @JsonProperty(value="icon_url")
        public abstract Builder iconUrl(String var1);

        @JsonProperty(value="icon_emoji")
        public abstract Builder iconEmoji(String var1);

        @JsonProperty(value="backlog_size")
        public abstract Builder backlogSize(long var1);

        @JsonProperty(value="time_zone")
        public abstract Builder timeZone(DateTimeZone var1);

        @JsonProperty(value="include_title")
        public abstract Builder includeTitle(Boolean var1);

        @JsonProperty(value="notify_here")
        public abstract Builder notifyHere(Boolean var1);

        public abstract SlackEventNotificationConfig build();
    }
}

