/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.map.geoip;

import com.codahale.metrics.Timer;
import com.google.inject.assistedinject.Assisted;
import com.maxmind.geoip2.exception.AddressNotFoundException;
import com.maxmind.geoip2.exception.GeoIp2Exception;
import com.maxmind.geoip2.model.AsnResponse;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Locale;
import java.util.Optional;
import javax.inject.Inject;
import org.graylog.plugins.map.geoip.GeoAsnInformation;
import org.graylog.plugins.map.geoip.MaxMindIpResolver;

public class MaxMindIpAsnResolver
extends MaxMindIpResolver<GeoAsnInformation> {
    @Inject
    public MaxMindIpAsnResolver(@Assisted Timer resolveTime, @Assisted String configPath, @Assisted boolean enabled) {
        super(resolveTime, configPath, enabled);
    }

    @Override
    protected Optional<GeoAsnInformation> doGetGeoIpData(InetAddress address) {
        GeoAsnInformation asn;
        block8: {
            try (Timer.Context ignored = this.resolveTime.time();){
                AsnResponse response = this.databaseReader.asn(address);
                String number = response.getAutonomousSystemNumber() == null ? "N/A" : response.getAutonomousSystemNumber().toString();
                asn = GeoAsnInformation.create(response.getAutonomousSystemOrganization(), "N/A", number);
            }
            catch (GeoIp2Exception | IOException | UnsupportedOperationException e) {
                asn = null;
                if (e instanceof AddressNotFoundException) break block8;
                String error = String.format(Locale.US, "Error getting ASN for IP Address '%s'. %s", address, e.getMessage());
                LOG.warn(error, e);
                this.lastError = e.getMessage();
            }
        }
        return Optional.ofNullable(asn);
    }
}

