/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.lookup;

import com.fasterxml.jackson.databind.node.ValueNode;
import com.google.common.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.AbstractFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.graylog.plugins.pipelineprocessor.rulebuilder.RuleBuilderFunctionGroup;
import org.graylog2.lookup.LookupTableService;
import org.graylog2.plugin.lookup.LookupResult;

public class LookupAll
extends AbstractFunction<List<Object>> {
    public static final String NAME = "lookup_all";
    private static final Class<List<Object>> LIST_RETURN_TYPE = new TypeToken<List<Object>>(){}.getRawType();
    private final ParameterDescriptor<String, LookupTableService.Function> lookupTableParam = ParameterDescriptor.string("lookup_table", LookupTableService.Function.class).description("The existing lookup table to use to lookup the given keys").transform(tableName -> lookupTableService.newBuilder().lookupTable((String)tableName).build()).build();
    private final ParameterDescriptor<Object, List<Object>> keysParam = ParameterDescriptor.object("keys", LIST_RETURN_TYPE).description("The keys to lookup in the table").transform(this::transformToList).build();

    @Inject
    public LookupAll(LookupTableService lookupTableService) {
    }

    @Override
    public List<Object> evaluate(FunctionArgs args, EvaluationContext context) {
        List<Object> keys = this.keysParam.required(args, context);
        if (keys == null || keys.isEmpty()) {
            return List.of();
        }
        LookupTableService.Function table = this.lookupTableParam.required(args, context);
        if (table == null) {
            return List.of();
        }
        ArrayList<Object> results = new ArrayList<Object>();
        for (Object key : keys) {
            LookupResult result = table.lookup(key);
            if (result == null || result.isEmpty()) continue;
            results.add(result.singleValue());
        }
        return results;
    }

    @Override
    public FunctionDescriptor<List<Object>> descriptor() {
        return FunctionDescriptor.builder().name(NAME).description("Looks up all provided values in the named lookup table, and returns all results as an array.").params(this.lookupTableParam, this.keysParam).returnType(LIST_RETURN_TYPE).ruleBuilderEnabled().ruleBuilderName("Lookup all values in lookup table").ruleBuilderTitle("Lookup all values from '${keys}' in '${lookup_table}'").ruleBuilderFunctionGroup(RuleBuilderFunctionGroup.LOOKUP).build();
    }

    private List<Object> transformToList(Object value) {
        if (value instanceof Collection) {
            return ((Collection)value).stream().map(LookupAll::convertValue).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return Collections.singletonList(value.toString());
    }

    private static String convertValue(Object o) {
        if (o instanceof ValueNode) {
            ValueNode node = (ValueNode)o;
            return node.textValue();
        }
        return o.toString();
    }
}

