/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.lookup;

import java.util.Optional;
import javax.inject.Inject;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.AbstractFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.graylog.plugins.pipelineprocessor.rulebuilder.RuleBuilderFunctionGroup;
import org.graylog2.lookup.LookupTableService;

public class LookupSetValue
extends AbstractFunction<Object> {
    public static final String NAME = "lookup_set_value";
    private final ParameterDescriptor<String, LookupTableService.Function> lookupTableParam = ParameterDescriptor.string("lookup_table", LookupTableService.Function.class).description("The existing lookup table to use to set the given value").transform(tableName -> lookupTableService.newBuilder().lookupTable((String)tableName).build()).build();
    private final ParameterDescriptor<Object, Object> keyParam = ParameterDescriptor.object("key").description("The key to set in the lookup table").build();
    private final ParameterDescriptor<Object, Object> valueParam = ParameterDescriptor.object("value").ruleBuilderVariable().description("The single value that should be set into the lookup table").build();
    private final ParameterDescriptor<Long, Long> ttlSecondsParam = ParameterDescriptor.integer("ttl").optional().description("The time to live in seconds to assign to this entry").build();

    @Inject
    public LookupSetValue(LookupTableService lookupTableService) {
    }

    @Override
    public Object evaluate(FunctionArgs args, EvaluationContext context) {
        Object key = this.keyParam.required(args, context);
        if (key == null) {
            return null;
        }
        LookupTableService.Function table = this.lookupTableParam.required(args, context);
        if (table == null) {
            return null;
        }
        Object value = this.valueParam.required(args, context);
        if (value == null) {
            return null;
        }
        Optional<Long> ttlSec = this.ttlSecondsParam.optional(args, context);
        if (ttlSec.isPresent()) {
            return table.setValueWithTtl(key, value, ttlSec.get()).singleValue();
        }
        return table.setValue(key, value).singleValue();
    }

    @Override
    public FunctionDescriptor<Object> descriptor() {
        return FunctionDescriptor.builder().name(NAME).description("Set a single value in the named lookup table. Returns the new value on success, null on failure.").params(this.lookupTableParam, this.keyParam, this.valueParam, this.ttlSecondsParam).returnType(Object.class).ruleBuilderEnabled().ruleBuilderName("Set value in lookup table").ruleBuilderTitle("Set value in '${lookup_table}' using key '${key}'").ruleBuilderFunctionGroup(RuleBuilderFunctionGroup.LOOKUP).build();
    }
}

