/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.rulebuilder.db.migrations;

import com.google.common.collect.ImmutableList;
import java.time.ZonedDateTime;
import javax.inject.Inject;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.graylog.plugins.pipelineprocessor.rulebuilder.RuleBuilderFunctionGroup;
import org.graylog.plugins.pipelineprocessor.rulebuilder.db.RuleFragment;
import org.graylog.plugins.pipelineprocessor.rulebuilder.db.RuleFragmentService;
import org.graylog2.migrations.Migration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V20220512123200_AddSimpleConditionFragments
extends Migration {
    private static final Logger log = LoggerFactory.getLogger(V20220512123200_AddSimpleConditionFragments.class);
    private final RuleFragmentService ruleFragmentService;

    @Inject
    public V20220512123200_AddSimpleConditionFragments(RuleFragmentService ruleFragmentService) {
        this.ruleFragmentService = ruleFragmentService;
    }

    @Override
    public ZonedDateTime createdAt() {
        return ZonedDateTime.parse("2023-05-12T12:32:00Z");
    }

    @Override
    public void upgrade() {
        this.ruleFragmentService.deleteAll();
        log.debug("Migrating simple condition fragments for the rule builder ui");
        this.ruleFragmentService.upsert(this.createHasFieldEqualsFragment());
        this.ruleFragmentService.upsert(this.createHasFieldGreateOrEqualFragment());
        this.ruleFragmentService.upsert(this.createHasFieldLessOrEqualFragment());
        log.debug("has_field_equals, has_field_greater_or_equal, has_field_less_or_equal fragments were successfully added");
    }

    private RuleFragment createHasFieldLessOrEqualFragment() {
        return RuleFragment.builder().fragment("( has_field(${field}) && to_long($message.${field}) <= ${fieldValue} )").descriptor(FunctionDescriptor.builder().name("has_field_less_or_equal").params((ImmutableList<ParameterDescriptor>)ImmutableList.of(ParameterDescriptor.string("field").description("Message field to check against").build(), ParameterDescriptor.integer("fieldValue").description("Field value to check for").build())).returnType(Boolean.class).description("Checks if the message has a field and if this field's numeric value is less than or equal to the given fieldValue").ruleBuilderEnabled().ruleBuilderName("Field <=").ruleBuilderTitle("Field '${field}' less than or equal '${fieldValue}'").ruleBuilderFunctionGroup(RuleBuilderFunctionGroup.NUMBER).build()).isCondition().build();
    }

    private RuleFragment createHasFieldGreateOrEqualFragment() {
        return RuleFragment.builder().fragment("( has_field(${field}) && to_long($message.${field}) >= ${fieldValue} )").descriptor(FunctionDescriptor.builder().name("has_field_greater_or_equal").params((ImmutableList<ParameterDescriptor>)ImmutableList.of(ParameterDescriptor.string("field").description("Message field to check against").build(), ParameterDescriptor.integer("fieldValue").description("Field value to check for").build())).returnType(Boolean.class).description("Checks if the message has a field and if this field's numeric value is greater than or equal to the given fieldValue").ruleBuilderEnabled().ruleBuilderName("Field >=").ruleBuilderTitle("Field '${field}' greater than or equal '${fieldValue}'").ruleBuilderFunctionGroup(RuleBuilderFunctionGroup.NUMBER).build()).isCondition().build();
    }

    private RuleFragment createHasFieldEqualsFragment() {
        return RuleFragment.builder().fragment("( has_field(${field}) &&\n<#if caseInsensitive!false>\nlowercase(to_string($message.${field})) == lowercase(${fieldValue})\n<#else>\nto_string($message.${field}) == ${fieldValue}\n</#if>\n)\n").descriptor(FunctionDescriptor.builder().name("has_field_equals").params((ImmutableList<ParameterDescriptor>)ImmutableList.of(ParameterDescriptor.string("field").description("Message field to check against").build(), ParameterDescriptor.string("fieldValue").description("Field value to check for").build(), ParameterDescriptor.bool("caseInsensitive").optional().description("Ignore case").build())).returnType(Boolean.class).description("Checks if the message has a field and if this field's string value is equal to the given fieldValue").ruleBuilderEnabled().ruleBuilderName("Field equals").ruleBuilderTitle("Field '${field}' equals '${fieldValue}' <#if caseInsensitive??>(case insensitive: ${caseInsensitive?c})</#if>").ruleBuilderFunctionGroup(RuleBuilderFunctionGroup.STRING).build()).isCondition().build();
    }
}

