/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.sidecar.services;

import com.google.common.base.Strings;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.graylog.plugins.sidecar.rest.models.ConfigurationVariable;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.PaginatedDbService;
import org.mongojack.DBQuery;

@Singleton
public class ConfigurationVariableService
extends PaginatedDbService<ConfigurationVariable> {
    private static final String COLLECTION_NAME = "sidecar_configuration_variables";

    @Inject
    public ConfigurationVariableService(MongoConnection mongoConnection, MongoJackObjectMapperProvider mapper) {
        super(mongoConnection, mapper, ConfigurationVariable.class, COLLECTION_NAME);
        this.db.createIndex((DBObject)new BasicDBObject("name", (Object)1), (DBObject)new BasicDBObject("unique", (Object)true));
    }

    public List<ConfigurationVariable> all() {
        try (Stream configurationVariableStream = this.streamQueryWithSort(DBQuery.empty(), this.getSortBuilder("asc", "name"));){
            List<ConfigurationVariable> list = configurationVariableStream.collect(Collectors.toList());
            return list;
        }
    }

    public ConfigurationVariable fromRequest(ConfigurationVariable request) {
        return ConfigurationVariable.create(request.name(), request.description(), request.content());
    }

    public ConfigurationVariable fromRequest(String id, ConfigurationVariable request) {
        return ConfigurationVariable.create(id, request.name(), request.description(), request.content());
    }

    public ConfigurationVariable find(String id) {
        return (ConfigurationVariable)this.db.findOne(DBQuery.is((String)"_id", (Object)id));
    }

    public ConfigurationVariable findByName(String name) {
        return (ConfigurationVariable)this.db.findOne(DBQuery.is((String)"name", (Object)name));
    }

    public boolean hasConflict(ConfigurationVariable variable) {
        DBQuery.Query query = Strings.isNullOrEmpty((String)variable.id()) ? DBQuery.is((String)"name", (Object)variable.name()) : DBQuery.and((DBQuery.Query[])new DBQuery.Query[]{DBQuery.is((String)"name", (Object)variable.name()), DBQuery.notEquals((String)"_id", (Object)variable.id())});
        return this.db.getCount(query) > 0L;
    }

    @Override
    public ConfigurationVariable save(ConfigurationVariable configurationVariable) {
        return (ConfigurationVariable)this.db.findAndModify(DBQuery.is((String)"_id", (Object)configurationVariable.id()), (DBObject)new BasicDBObject(), (DBObject)new BasicDBObject(), false, (Object)configurationVariable, true, true);
    }
}

