/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.graylog.plugins.views.search.Search;
import org.graylog.plugins.views.search.SearchExecutionGuard;
import org.graylog.plugins.views.search.db.SearchDbService;
import org.graylog.plugins.views.search.errors.PermissionException;
import org.graylog.plugins.views.search.permissions.SearchPermissions;
import org.graylog.plugins.views.search.permissions.SearchUser;
import org.graylog.plugins.views.search.views.ViewDTO;
import org.graylog.plugins.views.search.views.ViewResolver;
import org.graylog.plugins.views.search.views.ViewService;

public class SearchDomain {
    private final SearchDbService dbService;
    private final SearchExecutionGuard executionGuard;
    private final ViewService viewService;
    private final Map<String, ViewResolver> viewResolvers;

    @Inject
    public SearchDomain(SearchDbService dbService, SearchExecutionGuard executionGuard, ViewService viewService, Map<String, ViewResolver> viewResolvers) {
        this.dbService = dbService;
        this.executionGuard = executionGuard;
        this.viewService = viewService;
        this.viewResolvers = viewResolvers;
    }

    public Optional<Search> getForUser(String id, SearchUser searchUser) {
        Optional<Search> search = this.dbService.get(id);
        search.ifPresent(s -> this.checkPermission(searchUser, (Search)s));
        return search;
    }

    private void checkPermission(SearchUser searchUser, Search search) {
        if (!this.hasReadPermissionFor(searchUser, searchUser::canReadView, search)) {
            throw new PermissionException("User " + searchUser.username() + " does not have permission to load search " + search.id());
        }
    }

    public List<Search> getAllForUser(SearchPermissions searchPermissions, Predicate<ViewDTO> viewReadPermission) {
        return this.dbService.streamAll().filter(s -> this.hasReadPermissionFor(searchPermissions, viewReadPermission, (Search)s)).collect(Collectors.toList());
    }

    public Search saveForUser(Search search, SearchUser searchUser) {
        this.executionGuard.check(search, searchUser::canReadStream);
        Optional<Boolean> previous = Optional.ofNullable(search.id()).flatMap(this.dbService::get);
        if (!searchUser.isAdmin()) {
            if (!previous.map(searchUser::owns).orElse(true).booleanValue()) {
                throw new PermissionException("Unable to update search with id <" + search.id() + ">, already exists and user is not permitted to overwrite it.");
            }
        }
        return this.dbService.save(search.withOwner(searchUser.username()));
    }

    private boolean hasReadPermissionFor(SearchPermissions searchPermissions, Predicate<ViewDTO> viewReadPermission, Search search) {
        if (searchPermissions.owns(search)) {
            return true;
        }
        HashSet<ViewDTO> views = new HashSet<ViewDTO>();
        views.addAll(this.viewService.forSearch(search.id()));
        views.addAll(this.viewResolvers.values().stream().flatMap(viewResolver -> viewResolver.getBySearchId(search.id()).stream()).collect(Collectors.toSet()));
        if (views.isEmpty()) {
            return false;
        }
        return views.stream().anyMatch(viewReadPermission);
    }
}

