/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.rest.scriptingapi;

import com.google.common.eventbus.EventBus;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.ValidationException;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog.plugins.views.search.Search;
import org.graylog.plugins.views.search.SearchJob;
import org.graylog.plugins.views.search.engine.SearchExecutor;
import org.graylog.plugins.views.search.events.SearchJobExecutionEvent;
import org.graylog.plugins.views.search.permissions.SearchUser;
import org.graylog.plugins.views.search.rest.ExecutionState;
import org.graylog.plugins.views.search.rest.scriptingapi.mapping.AggregationTabularResponseCreator;
import org.graylog.plugins.views.search.rest.scriptingapi.mapping.MessagesTabularResponseCreator;
import org.graylog.plugins.views.search.rest.scriptingapi.mapping.QueryFailedException;
import org.graylog.plugins.views.search.rest.scriptingapi.mapping.QueryParamsToFullRequestSpecificationMapper;
import org.graylog.plugins.views.search.rest.scriptingapi.mapping.SearchRequestSpecToSearchMapper;
import org.graylog.plugins.views.search.rest.scriptingapi.request.AggregationRequestSpec;
import org.graylog.plugins.views.search.rest.scriptingapi.request.MessagesRequestSpec;
import org.graylog.plugins.views.search.rest.scriptingapi.response.TabularResponse;
import org.graylog.plugins.views.search.searchtypes.pivot.SortSpec;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.plugin.rest.PluginRestResource;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.shared.utilities.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

@Api(value="Search/Simple", description="Simple search API for aggregating and messages retrieval", tags={"cloud"})
@Path(value="/search")
@Consumes(value={"application/json"})
@RequiresAuthentication
public class ScriptingApiResource
extends RestResource
implements PluginRestResource {
    private final SearchExecutor searchExecutor;
    private final EventBus serverEventBus;
    private final SearchRequestSpecToSearchMapper searchCreator;
    private final AggregationTabularResponseCreator aggregationTabularResponseCreator;
    private final MessagesTabularResponseCreator messagesTabularResponseCreator;
    private final QueryParamsToFullRequestSpecificationMapper queryParamsToFullRequestSpecificationMapper;

    @Inject
    public ScriptingApiResource(SearchExecutor searchExecutor, EventBus serverEventBus, SearchRequestSpecToSearchMapper searchCreator, AggregationTabularResponseCreator aggregationTabularResponseCreator, MessagesTabularResponseCreator messagesTabularResponseCreator, QueryParamsToFullRequestSpecificationMapper queryParamsToFullRequestSpecificationMapper) {
        this.searchExecutor = searchExecutor;
        this.serverEventBus = serverEventBus;
        this.searchCreator = searchCreator;
        this.aggregationTabularResponseCreator = aggregationTabularResponseCreator;
        this.messagesTabularResponseCreator = messagesTabularResponseCreator;
        this.queryParamsToFullRequestSpecificationMapper = queryParamsToFullRequestSpecificationMapper;
    }

    @POST
    @ApiOperation(value="Execute query specified by `queryRequestSpec`", nickname="messagesByQueryRequestSpec", response=TabularResponse.class)
    @Path(value="messages")
    @NoAuditEvent(value="Creating audit event manually in method body.")
    public TabularResponse executeQuery(@ApiParam(name="queryRequestSpec") @Valid MessagesRequestSpec messagesRequestSpec, @Context SearchUser searchUser) {
        try {
            Search search = this.searchCreator.mapToSearch(messagesRequestSpec, searchUser);
            SearchJob searchJob = this.searchExecutor.execute(search, searchUser, ExecutionState.empty());
            this.postAuditEvent(searchJob);
            return this.messagesTabularResponseCreator.mapToResponse(messagesRequestSpec, searchJob, searchUser, this.getSubject());
        }
        catch (IllegalArgumentException | ValidationException | QueryFailedException ex) {
            throw new BadRequestException(ex.getMessage(), ex);
        }
    }

    @GET
    @ApiOperation(value="Execute query specified by query parameters", nickname="messagesByQueryParameters")
    @Path(value="messages")
    @NoAuditEvent(value="Creating audit event manually in method body.")
    public TabularResponse executeQuery(@ApiParam(name="query") @QueryParam(value="query") String query, @ApiParam(name="streams") @QueryParam(value="streams") Set<String> streams, @ApiParam(name="timerange") @QueryParam(value="timerange") String timerangeKeyword, @ApiParam(name="fields") @QueryParam(value="fields") List<String> fields, @ApiParam(name="sort") @QueryParam(value="sort") String sort, @ApiParam(name="sort") @QueryParam(value="sortOrder") SortSpec.Direction sortOrder, @ApiParam(name="from") @QueryParam(value="from") int from, @ApiParam(name="size") @QueryParam(value="size") int size, @Context SearchUser searchUser) {
        try {
            MessagesRequestSpec messagesRequestSpec = this.queryParamsToFullRequestSpecificationMapper.simpleQueryParamsToFullRequestSpecification(query, StringUtils.splitByComma(streams), timerangeKeyword, StringUtils.splitByComma(fields), sort, sortOrder, from, size);
            return this.executeQuery(messagesRequestSpec, searchUser);
        }
        catch (IllegalArgumentException ex) {
            throw new BadRequestException(ex.getMessage(), (Throwable)ex);
        }
    }

    @POST
    @ApiOperation(value="Execute aggregation specified by `searchRequestSpec`", nickname="aggregateSearchRequestSpec", response=TabularResponse.class)
    @Path(value="aggregate")
    @NoAuditEvent(value="Creating audit event manually in method body.")
    public TabularResponse executeQuery(@ApiParam(name="searchRequestSpec") @Valid AggregationRequestSpec aggregationRequestSpec, @Context SearchUser searchUser) {
        try {
            Search search = this.searchCreator.mapToSearch(aggregationRequestSpec, searchUser);
            SearchJob searchJob = this.searchExecutor.execute(search, searchUser, ExecutionState.empty());
            this.postAuditEvent(searchJob);
            return this.aggregationTabularResponseCreator.mapToResponse(aggregationRequestSpec, searchJob, searchUser);
        }
        catch (IllegalArgumentException | ValidationException | QueryFailedException ex) {
            throw new BadRequestException(ex.getMessage(), ex);
        }
    }

    @GET
    @ApiOperation(value="Execute aggregation specified by query parameters", nickname="aggregateForQueryParameters")
    @Path(value="aggregate")
    @NoAuditEvent(value="Creating audit event manually in method body.")
    public TabularResponse executeQuery(@ApiParam(name="query") @QueryParam(value="query") String query, @ApiParam(name="streams") @QueryParam(value="streams") Set<String> streams, @ApiParam(name="timerange") @QueryParam(value="timerange") String timerangeKeyword, @ApiParam(name="groups") @QueryParam(value="groups") List<String> groups, @ApiParam(name="metrics") @QueryParam(value="metrics") List<String> metrics, @Context SearchUser searchUser) {
        try {
            AggregationRequestSpec aggregationRequestSpec = this.queryParamsToFullRequestSpecificationMapper.simpleQueryParamsToFullRequestSpecification(query, StringUtils.splitByComma(streams), timerangeKeyword, StringUtils.splitByComma(groups), StringUtils.splitByComma(metrics));
            return this.executeQuery(aggregationRequestSpec, searchUser);
        }
        catch (IllegalArgumentException ex) {
            throw new BadRequestException(ex.getMessage(), (Throwable)ex);
        }
    }

    private void postAuditEvent(SearchJob searchJob) {
        SearchJobExecutionEvent searchJobExecutionEvent = SearchJobExecutionEvent.create(this.getCurrentUser(), searchJob, DateTime.now((DateTimeZone)DateTimeZone.UTC));
        this.serverEventBus.post((Object)searchJobExecutionEvent);
    }
}

