/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.cluster;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.eventbus.EventBus;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.WriteConcern;
import java.util.Set;
import javax.inject.Inject;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.cluster.ClusterConfig;
import org.graylog2.cluster.ClusterConfigChangedEvent;
import org.graylog2.database.MongoConnection;
import org.graylog2.events.ClusterEventBus;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.system.NodeId;
import org.graylog2.security.RestrictedChainingClassLoader;
import org.graylog2.security.SafeClasses;
import org.graylog2.security.UnsafeClassLoadingAttemptException;
import org.graylog2.shared.plugins.ChainingClassLoader;
import org.graylog2.shared.utilities.AutoValueUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.mongojack.DBCursor;
import org.mongojack.DBQuery;
import org.mongojack.DBSort;
import org.mongojack.JacksonDBCollection;
import org.mongojack.WriteResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterConfigServiceImpl
implements ClusterConfigService {
    @VisibleForTesting
    static final String COLLECTION_NAME = "cluster_config";
    private static final Logger LOG = LoggerFactory.getLogger(ClusterConfigServiceImpl.class);
    private final JacksonDBCollection<ClusterConfig, String> dbCollection;
    private final NodeId nodeId;
    private final ObjectMapper objectMapper;
    private final RestrictedChainingClassLoader chainingClassLoader;
    private final EventBus clusterEventBus;

    @Inject
    public ClusterConfigServiceImpl(MongoJackObjectMapperProvider mapperProvider, MongoConnection mongoConnection, NodeId nodeId, RestrictedChainingClassLoader chainingClassLoader, ClusterEventBus clusterEventBus) {
        this((JacksonDBCollection<ClusterConfig, String>)JacksonDBCollection.wrap((DBCollection)ClusterConfigServiceImpl.prepareCollection(mongoConnection), ClusterConfig.class, String.class, (ObjectMapper)mapperProvider.get()), nodeId, mapperProvider.get(), chainingClassLoader, (EventBus)clusterEventBus);
    }

    @Deprecated
    public ClusterConfigServiceImpl(MongoJackObjectMapperProvider mapperProvider, MongoConnection mongoConnection, NodeId nodeId, ChainingClassLoader chainingClassLoader, ClusterEventBus clusterEventBus) {
        this((JacksonDBCollection<ClusterConfig, String>)JacksonDBCollection.wrap((DBCollection)ClusterConfigServiceImpl.prepareCollection(mongoConnection), ClusterConfig.class, String.class, (ObjectMapper)mapperProvider.get()), nodeId, mapperProvider.get(), new RestrictedChainingClassLoader(chainingClassLoader, SafeClasses.allGraylogInternal()), (EventBus)clusterEventBus);
    }

    private ClusterConfigServiceImpl(JacksonDBCollection<ClusterConfig, String> dbCollection, NodeId nodeId, ObjectMapper objectMapper, RestrictedChainingClassLoader chainingClassLoader, EventBus clusterEventBus) {
        this.nodeId = (NodeId)Preconditions.checkNotNull((Object)nodeId);
        this.dbCollection = (JacksonDBCollection)Preconditions.checkNotNull(dbCollection);
        this.objectMapper = (ObjectMapper)Preconditions.checkNotNull((Object)objectMapper);
        this.chainingClassLoader = chainingClassLoader;
        this.clusterEventBus = (EventBus)Preconditions.checkNotNull((Object)clusterEventBus);
    }

    @VisibleForTesting
    static DBCollection prepareCollection(MongoConnection mongoConnection) {
        DBCollection coll = mongoConnection.getDatabase().getCollection(COLLECTION_NAME);
        coll.createIndex((DBObject)DBSort.asc((String)"type"), "unique_type", true);
        coll.setWriteConcern(WriteConcern.JOURNALED);
        return coll;
    }

    @Override
    public <T> T extractPayload(Object payload, Class<T> type) {
        try {
            return (T)this.objectMapper.convertValue(payload, type);
        }
        catch (IllegalArgumentException e) {
            LOG.error("Error while deserializing payload", (Throwable)e);
            return null;
        }
    }

    @Override
    public <T> T get(String key, Class<T> type) {
        ClusterConfig config = this.findClusterConfig(key);
        if (config == null) {
            LOG.debug("Couldn't find cluster config of type {}", (Object)key);
            return null;
        }
        T result = this.extractPayload(config.payload(), type);
        if (result == null) {
            LOG.error("Couldn't extract payload from cluster config (type: {})", (Object)key);
        }
        return result;
    }

    private ClusterConfig findClusterConfig(String key) {
        return (ClusterConfig)this.dbCollection.findOne(DBQuery.is((String)"type", (Object)key));
    }

    @Override
    public <T> T get(Class<T> type) {
        return this.get(type.getCanonicalName(), type);
    }

    @Override
    public ClusterConfig getRaw(Class<?> type) {
        return this.findClusterConfig(type.getCanonicalName());
    }

    @Override
    public <T> T getOrDefault(Class<T> type, T defaultValue) {
        return (T)MoreObjects.firstNonNull(this.get(type), defaultValue);
    }

    @Override
    public <T> void write(T payload) {
        if (payload == null) {
            LOG.debug("Payload was null. Skipping.");
            return;
        }
        String canonicalClassName = AutoValueUtils.getCanonicalName(payload.getClass());
        this.write(canonicalClassName, payload);
    }

    @Override
    public <T> void write(String key, T payload) {
        if (payload == null) {
            LOG.debug("Payload was null. Skipping.");
            return;
        }
        ClusterConfig clusterConfig = ClusterConfig.create(key, payload, this.nodeId.getNodeId());
        this.dbCollection.update(DBQuery.is((String)"type", (Object)key), (Object)clusterConfig, true, false, WriteConcern.JOURNALED);
        ClusterConfigChangedEvent event = ClusterConfigChangedEvent.create(DateTime.now((DateTimeZone)DateTimeZone.UTC), this.nodeId.getNodeId(), key);
        this.clusterEventBus.post((Object)event);
    }

    @Override
    public <T> int remove(Class<T> type) {
        String canonicalName = type.getCanonicalName();
        WriteResult result = this.dbCollection.remove(DBQuery.is((String)"type", (Object)canonicalName));
        return result.getN();
    }

    @Override
    public Set<Class<?>> list() {
        ImmutableSet.Builder classes = ImmutableSet.builder();
        try (DBCursor clusterConfigs = this.dbCollection.find();){
            for (ClusterConfig clusterConfig : clusterConfigs) {
                String type = clusterConfig.type();
                try {
                    Class<?> cls = this.chainingClassLoader.loadClassSafely(type);
                    classes.add(cls);
                }
                catch (ClassNotFoundException e) {
                    LOG.debug("Couldn't find configuration class \"{}\"", (Object)type, (Object)e);
                }
                catch (UnsafeClassLoadingAttemptException e) {
                    LOG.warn("Couldn't load class <{}>.", (Object)type, (Object)e);
                }
            }
        }
        return classes.build();
    }
}

