/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.cluster.certificates;

import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.Indexes;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.Updates;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import java.util.Optional;
import javax.inject.Inject;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.graylog.security.certutil.keystore.storage.location.KeystoreMongoCollection;
import org.graylog.security.certutil.keystore.storage.location.KeystoreMongoCollections;
import org.graylog.security.certutil.keystore.storage.location.KeystoreMongoLocation;
import org.graylog2.database.MongoConnection;
import org.graylog2.security.encryption.EncryptedValue;
import org.graylog2.security.encryption.EncryptedValueService;

public class CertificatesService {
    private static final String ENCRYPTED_VALUE_SUBFIELD = "encrypted_value";
    private static final String SALT_SUBFIELD = "salt";
    private final MongoDatabase mongoDatabase;
    private final EncryptedValueService encryptionService;

    @Inject
    public CertificatesService(MongoConnection mongoConnection, EncryptedValueService encryptionService) {
        this.mongoDatabase = mongoConnection.getMongoDatabase();
        this.encryptionService = encryptionService;
        KeystoreMongoCollections.ALL_KEYSTORE_COLLECTIONS.forEach(collection -> {
            MongoCollection dbCollection = this.mongoDatabase.getCollection(collection.collectionName());
            dbCollection.createIndex(Indexes.ascending((String[])new String[]{collection.identifierField()}), new IndexOptions().unique(true));
        });
    }

    public boolean writeCert(KeystoreMongoLocation keystoreMongoLocation, String cert) {
        KeystoreMongoCollection collection = keystoreMongoLocation.collection();
        MongoCollection dbCollection = this.mongoDatabase.getCollection(collection.collectionName());
        EncryptedValue encrypted = this.encryptionService.encrypt(cert);
        UpdateResult result = dbCollection.updateOne(Filters.eq((String)collection.identifierField(), (Object)keystoreMongoLocation.nodeId()), Updates.combine((Bson[])new Bson[]{Updates.set((String)collection.identifierField(), (Object)keystoreMongoLocation.nodeId()), Updates.set((String)(collection.encryptedCertificateField() + ".encrypted_value"), (Object)encrypted.value()), Updates.set((String)(collection.encryptedCertificateField() + ".salt"), (Object)encrypted.salt())}), new UpdateOptions().upsert(true));
        return result.getModifiedCount() > 0L || result.getUpsertedId() != null;
    }

    public boolean hasCert(KeystoreMongoLocation keystoreMongoLocation) {
        Document encryptedCertificateDocument;
        KeystoreMongoCollection collection = keystoreMongoLocation.collection();
        MongoCollection dbCollection = this.mongoDatabase.getCollection(collection.collectionName());
        FindIterable objects = dbCollection.find(Filters.eq((String)collection.identifierField(), (Object)keystoreMongoLocation.nodeId()));
        Document nodeCertificate = (Document)objects.first();
        return nodeCertificate != null && (encryptedCertificateDocument = (Document)nodeCertificate.get((Object)collection.encryptedCertificateField(), Document.class)) != null;
    }

    public Optional<String> readCert(KeystoreMongoLocation keystoreMongoLocation) {
        Document encryptedCertificateDocument;
        KeystoreMongoCollection collection = keystoreMongoLocation.collection();
        MongoCollection dbCollection = this.mongoDatabase.getCollection(collection.collectionName());
        FindIterable objects = dbCollection.find(Filters.eq((String)collection.identifierField(), (Object)keystoreMongoLocation.nodeId()));
        Document nodeCertificate = (Document)objects.first();
        if (nodeCertificate != null && (encryptedCertificateDocument = (Document)nodeCertificate.get((Object)collection.encryptedCertificateField(), Document.class)) != null) {
            EncryptedValue encryptedCertificate = EncryptedValue.builder().value(encryptedCertificateDocument.getString((Object)ENCRYPTED_VALUE_SUBFIELD)).salt(encryptedCertificateDocument.getString((Object)SALT_SUBFIELD)).isDeleteValue(false).isKeepValue(false).build();
            return Optional.ofNullable(this.encryptionService.decrypt(encryptedCertificate));
        }
        return Optional.empty();
    }

    public boolean removeCert(KeystoreMongoLocation keystoreMongoLocation) {
        KeystoreMongoCollection collection = keystoreMongoLocation.collection();
        MongoCollection dbCollection = this.mongoDatabase.getCollection(collection.collectionName());
        DeleteResult result = dbCollection.deleteOne(Filters.eq((String)collection.identifierField(), (Object)keystoreMongoLocation.nodeId()));
        return result.getDeletedCount() > 0L;
    }
}

