/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.configuration;

import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.graylog2.configuration.ElasticsearchConfiguration;
import org.graylog2.configuration.IndexSetsDefaultConfiguration;
import org.graylog2.indexer.indexset.IndexSetConfig;
import org.graylog2.migrations.MaintenanceStrategiesHelper;
import org.graylog2.plugin.indexer.retention.RetentionStrategyConfig;
import org.graylog2.plugin.indexer.rotation.RotationStrategyConfig;

public class IndexSetsDefaultConfigurationFactory {
    private final ElasticsearchConfiguration elasticsearchConfiguration;
    private final MaintenanceStrategiesHelper maintenanceStrategiesHelper;

    @Inject
    public IndexSetsDefaultConfigurationFactory(ElasticsearchConfiguration elasticsearchConfiguration, MaintenanceStrategiesHelper maintenanceStrategiesHelper) {
        this.elasticsearchConfiguration = elasticsearchConfiguration;
        this.maintenanceStrategiesHelper = maintenanceStrategiesHelper;
    }

    public IndexSetsDefaultConfiguration create() {
        ImmutablePair<String, RotationStrategyConfig> rotationConfig = this.maintenanceStrategiesHelper.readRotationConfigFromServerConf();
        ImmutablePair<String, RetentionStrategyConfig> retentionConfig = this.maintenanceStrategiesHelper.readRetentionConfigFromServerConf();
        return IndexSetsDefaultConfiguration.builder().indexAnalyzer(this.elasticsearchConfiguration.getAnalyzer()).shards(this.elasticsearchConfiguration.getShards()).replicas(this.elasticsearchConfiguration.getReplicas()).indexOptimizationDisabled(this.elasticsearchConfiguration.isDisableIndexOptimization()).indexOptimizationMaxNumSegments(this.elasticsearchConfiguration.getIndexOptimizationMaxNumSegments()).fieldTypeRefreshInterval(IndexSetConfig.DEFAULT_FIELD_TYPE_REFRESH_INTERVAL.getStandardSeconds()).fieldTypeRefreshIntervalUnit(TimeUnit.SECONDS).rotationStrategyClass((String)rotationConfig.left).rotationStrategyConfig((RotationStrategyConfig)rotationConfig.right).retentionStrategyClass((String)retentionConfig.left).retentionStrategyConfig((RetentionStrategyConfig)retentionConfig.right).build();
    }
}

