/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.contentpacks.facades;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.ImmutableGraph;
import com.google.common.graph.MutableGraph;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.graylog.plugins.pipelineprocessor.ast.Pipeline;
import org.graylog.plugins.pipelineprocessor.ast.Stage;
import org.graylog.plugins.pipelineprocessor.db.PipelineDao;
import org.graylog.plugins.pipelineprocessor.db.PipelineService;
import org.graylog.plugins.pipelineprocessor.db.PipelineStreamConnectionsService;
import org.graylog.plugins.pipelineprocessor.db.RuleDao;
import org.graylog.plugins.pipelineprocessor.db.RuleService;
import org.graylog.plugins.pipelineprocessor.parser.PipelineRuleParser;
import org.graylog.plugins.pipelineprocessor.rest.PipelineConnections;
import org.graylog2.contentpacks.EntityDescriptorIds;
import org.graylog2.contentpacks.exceptions.MissingNativeEntityException;
import org.graylog2.contentpacks.facades.EntityFacade;
import org.graylog2.contentpacks.facades.StreamReferenceFacade;
import org.graylog2.contentpacks.model.ModelId;
import org.graylog2.contentpacks.model.ModelType;
import org.graylog2.contentpacks.model.ModelTypes;
import org.graylog2.contentpacks.model.entities.Entity;
import org.graylog2.contentpacks.model.entities.EntityDescriptor;
import org.graylog2.contentpacks.model.entities.EntityExcerpt;
import org.graylog2.contentpacks.model.entities.EntityV1;
import org.graylog2.contentpacks.model.entities.NativeEntity;
import org.graylog2.contentpacks.model.entities.NativeEntityDescriptor;
import org.graylog2.contentpacks.model.entities.PipelineEntity;
import org.graylog2.contentpacks.model.entities.references.ValueReference;
import org.graylog2.database.NotFoundException;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.streams.StreamService;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineFacade
implements EntityFacade<PipelineDao> {
    private static final Logger LOG = LoggerFactory.getLogger(PipelineFacade.class);
    public static final ModelType TYPE_V1 = ModelTypes.PIPELINE_V1;
    private final ObjectMapper objectMapper;
    private final PipelineService pipelineService;
    private final PipelineStreamConnectionsService connectionsService;
    private final PipelineRuleParser pipelineRuleParser;
    private final RuleService ruleService;
    private final StreamService streamService;

    @Inject
    public PipelineFacade(ObjectMapper objectMapper, PipelineService pipelineService, PipelineStreamConnectionsService connectionsService, PipelineRuleParser pipelineRuleParser, RuleService rulesService, StreamService streamService) {
        this.objectMapper = objectMapper;
        this.pipelineService = pipelineService;
        this.connectionsService = connectionsService;
        this.pipelineRuleParser = pipelineRuleParser;
        this.ruleService = rulesService;
        this.streamService = streamService;
    }

    @VisibleForTesting
    Entity exportNativeEntity(PipelineDao pipelineDao, EntityDescriptorIds entityDescriptorIds) {
        Set<ValueReference> connectedStreams = this.connectedStreams(pipelineDao.id(), entityDescriptorIds);
        PipelineEntity pipelineEntity = PipelineEntity.create(ValueReference.of(pipelineDao.title()), ValueReference.of(pipelineDao.description()), ValueReference.of(pipelineDao.source()), connectedStreams);
        JsonNode data = (JsonNode)this.objectMapper.convertValue((Object)pipelineEntity, JsonNode.class);
        return ((EntityV1.Builder)((EntityV1.Builder)EntityV1.builder().id(ModelId.of(entityDescriptorIds.getOrThrow(pipelineDao.id(), ModelTypes.PIPELINE_V1)))).type(ModelTypes.PIPELINE_V1)).data(data).build();
    }

    private Set<ValueReference> connectedStreams(String pipelineId, EntityDescriptorIds entityDescriptorIds) {
        Set<PipelineConnections> connections = this.connectionsService.loadByPipelineId(pipelineId);
        return connections.stream().map(pipelineConnections -> StreamReferenceFacade.getStreamEntityIdOrThrow(pipelineConnections.streamId(), entityDescriptorIds)).map(ValueReference::of).collect(Collectors.toSet());
    }

    @Override
    public NativeEntity<PipelineDao> createNativeEntity(Entity entity, Map<String, ValueReference> parameters, Map<EntityDescriptor, Object> nativeEntities, String username) {
        if (entity instanceof EntityV1) {
            return this.decode((EntityV1)entity, parameters, nativeEntities);
        }
        throw new IllegalArgumentException("Unsupported entity version: " + entity.getClass());
    }

    private NativeEntity<PipelineDao> decode(EntityV1 entity, Map<String, ValueReference> parameters, Map<EntityDescriptor, Object> nativeEntities) {
        DateTime now = Tools.nowUTC();
        PipelineEntity pipelineEntity = (PipelineEntity)this.objectMapper.convertValue((Object)entity.data(), PipelineEntity.class);
        ValueReference description = pipelineEntity.description();
        PipelineDao pipelineDao = PipelineDao.builder().title(pipelineEntity.title().asString(parameters)).description(description == null ? null : description.asString(parameters)).source(pipelineEntity.source().asString(parameters)).createdAt(now).modifiedAt(now).build();
        PipelineDao savedPipelineDao = this.pipelineService.save(pipelineDao);
        String pipelineId = Objects.requireNonNull(savedPipelineDao.id(), "Saved pipeline ID must not be null");
        Set<EntityDescriptor> connectedStreamEntities = pipelineEntity.connectedStreams().stream().map(valueReference -> valueReference.asString(parameters)).map(streamId -> EntityDescriptor.create(streamId, ModelTypes.STREAM_V1)).collect(Collectors.toSet());
        Set<Stream> connectedStreams = this.connectedStreams(connectedStreamEntities, nativeEntities);
        this.createPipelineConnections(pipelineId, connectedStreams);
        return NativeEntity.create(entity.id(), pipelineId, TYPE_V1, savedPipelineDao.title(), savedPipelineDao);
    }

    private Set<Stream> connectedStreams(Set<EntityDescriptor> connectedStreamEntities, Map<EntityDescriptor, Object> nativeEntities) {
        ImmutableSet.Builder streams = ImmutableSet.builder();
        for (EntityDescriptor descriptor : connectedStreamEntities) {
            Object stream = StreamReferenceFacade.resolveStreamEntityObject(descriptor.id().id(), nativeEntities);
            if (stream instanceof Stream) {
                streams.add((Object)((Stream)stream));
                continue;
            }
            if (EntityDescriptorIds.isSystemStreamDescriptor(descriptor)) {
                try {
                    streams.add((Object)this.streamService.load(descriptor.id().id()));
                    continue;
                }
                catch (NotFoundException e) {
                    LOG.warn("Default stream {} not found!", (Object)descriptor.id().id(), (Object)e);
                    throw new MissingNativeEntityException(descriptor);
                }
            }
            throw new MissingNativeEntityException(descriptor);
        }
        return streams.build();
    }

    private void createPipelineConnections(String pipelineId, Set<Stream> connectedStreams) {
        for (Stream stream : connectedStreams) {
            String streamId = stream.getId();
            try {
                PipelineConnections connections = this.connectionsService.load(streamId);
                ImmutableSet newPipelines = ImmutableSet.builder().addAll(connections.pipelineIds()).add((Object)pipelineId).build();
                PipelineConnections newConnections = connections.toBuilder().pipelineIds((Set<String>)newPipelines).build();
                PipelineConnections savedConnections = this.connectionsService.save(newConnections);
                LOG.trace("Saved pipeline connections: {}", (Object)savedConnections);
            }
            catch (NotFoundException e) {
                PipelineConnections connections = PipelineConnections.builder().streamId(streamId).pipelineIds(Collections.singleton(pipelineId)).build();
                PipelineConnections savedConnections = this.connectionsService.save(connections);
                LOG.trace("Saved pipeline connections: {}", (Object)savedConnections);
            }
        }
    }

    @Override
    public Optional<NativeEntity<PipelineDao>> loadNativeEntity(NativeEntityDescriptor nativeEntityDescriptor) {
        try {
            PipelineDao pipeline = this.pipelineService.load(nativeEntityDescriptor.id().id());
            return Optional.of(NativeEntity.create(nativeEntityDescriptor, pipeline));
        }
        catch (NotFoundException e) {
            return Optional.empty();
        }
    }

    @Override
    public void delete(PipelineDao nativeEntity) {
        Set<PipelineConnections> pipelineConnections = this.connectionsService.loadByPipelineId(nativeEntity.id());
        for (PipelineConnections connections : pipelineConnections) {
            Set<String> pipelineIds = connections.pipelineIds().stream().filter(pipelineId -> !pipelineId.equals(nativeEntity.id())).collect(Collectors.toSet());
            if (pipelineIds.isEmpty()) {
                LOG.trace("Removing pipeline connections for stream {}", (Object)connections.streamId());
                this.connectionsService.delete(connections.streamId());
                continue;
            }
            PipelineConnections newConnections = connections.toBuilder().pipelineIds(pipelineIds).build();
            LOG.trace("Saving updated pipeline connections: {}", (Object)newConnections);
            this.connectionsService.save(newConnections);
        }
        this.pipelineService.delete(nativeEntity.id());
    }

    @Override
    public EntityExcerpt createExcerpt(PipelineDao pipeline) {
        return ((EntityExcerpt.Builder)((EntityExcerpt.Builder)EntityExcerpt.builder().id(ModelId.of(pipeline.id()))).type(ModelTypes.PIPELINE_V1)).title(pipeline.title()).build();
    }

    @Override
    public Set<EntityExcerpt> listEntityExcerpts() {
        return this.pipelineService.loadAll().stream().map(this::createExcerpt).collect(Collectors.toSet());
    }

    @Override
    public Optional<Entity> exportEntity(EntityDescriptor entityDescriptor, EntityDescriptorIds entityDescriptorIds) {
        ModelId modelId = entityDescriptor.id();
        try {
            PipelineDao pipelineDao = this.pipelineService.load(modelId.id());
            return Optional.of(this.exportNativeEntity(pipelineDao, entityDescriptorIds));
        }
        catch (NotFoundException e) {
            LOG.debug("Couldn't find pipeline {}", (Object)entityDescriptor, (Object)e);
            return Optional.empty();
        }
    }

    @Override
    public Graph<EntityDescriptor> resolveNativeEntity(EntityDescriptor entityDescriptor) {
        MutableGraph mutableGraph = GraphBuilder.directed().build();
        mutableGraph.addNode((Object)entityDescriptor);
        ModelId modelId = entityDescriptor.id();
        try {
            PipelineDao pipelineDao = this.pipelineService.load(modelId.id());
            String pipelineSource = pipelineDao.source();
            Collection<String> referencedRules = this.referencedRules(pipelineSource);
            referencedRules.stream().map(ModelId::of).map(id -> EntityDescriptor.create(id, ModelTypes.PIPELINE_RULE_V1)).forEach(rule -> mutableGraph.putEdge((Object)entityDescriptor, rule));
            Set<PipelineConnections> pipelineConnections = this.connectionsService.loadByPipelineId(pipelineDao.id());
            pipelineConnections.stream().map(PipelineConnections::streamId).map(ModelId::of).map(id -> EntityDescriptor.create(id, ModelTypes.STREAM_REF_V1)).forEach(stream -> mutableGraph.putEdge((Object)entityDescriptor, stream));
        }
        catch (NotFoundException e) {
            LOG.debug("Couldn't find pipeline {}", (Object)entityDescriptor, (Object)e);
        }
        return ImmutableGraph.copyOf((Graph)mutableGraph);
    }

    @Override
    public Graph<Entity> resolveForInstallation(Entity entity, Map<String, ValueReference> parameters, Map<EntityDescriptor, Entity> entities) {
        if (entity instanceof EntityV1) {
            return this.resolveForInstallation((EntityV1)entity, parameters, entities);
        }
        throw new IllegalArgumentException("Unsupported entity version: " + entity.getClass());
    }

    private Graph<Entity> resolveForInstallation(EntityV1 entity, Map<String, ValueReference> parameters, Map<EntityDescriptor, Entity> entities) {
        MutableGraph mutableGraph = GraphBuilder.directed().build();
        mutableGraph.addNode((Object)entity);
        PipelineEntity pipelineEntity = (PipelineEntity)this.objectMapper.convertValue((Object)entity.data(), PipelineEntity.class);
        String source = pipelineEntity.source().asString(parameters);
        Collection<String> referencedRules = this.referencedRules(source);
        referencedRules.stream().map(ModelId::of).map(modelId -> EntityDescriptor.create(modelId, ModelTypes.PIPELINE_RULE_V1)).map(entities::get).filter(Objects::nonNull).forEach(ruleEntity -> mutableGraph.putEdge((Object)entity, ruleEntity));
        pipelineEntity.connectedStreams().stream().map(valueReference -> valueReference.asString(parameters)).map(id -> StreamReferenceFacade.resolveStreamEntity(id, entities)).filter(Objects::nonNull).forEach(streamEntity -> mutableGraph.putEdge((Object)entity, streamEntity));
        return ImmutableGraph.copyOf((Graph)mutableGraph);
    }

    private Collection<String> referencedRules(String pipelineSource) {
        Pipeline pipeline = this.pipelineRuleParser.parsePipeline("dummy", pipelineSource);
        return pipeline.stages().stream().map(Stage::ruleReferences).flatMap(Collection::stream).map(this.ruleService::findByName).filter(Optional::isPresent).map(Optional::get).map(RuleDao::id).collect(Collectors.toSet());
    }
}

