/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.retention.strategies;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.graylog.scheduler.clock.JobSchedulerClock;
import org.graylog2.indexer.IndexSet;
import org.graylog2.indexer.indices.Indices;
import org.graylog2.indexer.rotation.strategies.TimeBasedSizeOptimizingStrategyConfig;
import org.graylog2.periodical.IndexRetentionThread;
import org.graylog2.plugin.indexer.retention.RetentionStrategy;
import org.graylog2.plugin.indexer.rotation.RotationStrategyConfig;
import org.graylog2.shared.system.activities.Activity;
import org.graylog2.shared.system.activities.ActivityWriter;
import org.graylog2.shared.utilities.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadablePeriod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractIndexRetentionStrategy
implements RetentionStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractIndexRetentionStrategy.class);
    private final Indices indices;
    private final ActivityWriter activityWriter;
    private JobSchedulerClock clock;

    protected AbstractIndexRetentionStrategy(Indices indices, ActivityWriter activityWriter, JobSchedulerClock clock) {
        this.indices = Objects.requireNonNull(indices);
        this.activityWriter = Objects.requireNonNull(activityWriter);
        this.clock = clock;
    }

    protected abstract Optional<Integer> getMaxNumberOfIndices(IndexSet var1);

    protected abstract void retain(List<String> var1, IndexSet var2);

    @Override
    public void retain(IndexSet indexSet) {
        RotationStrategyConfig rotationStrategyConfig = indexSet.getConfig().rotationStrategy();
        if (rotationStrategyConfig instanceof TimeBasedSizeOptimizingStrategyConfig) {
            TimeBasedSizeOptimizingStrategyConfig timeBasedConfig = (TimeBasedSizeOptimizingStrategyConfig)rotationStrategyConfig;
            this.retainTimeBased(indexSet, timeBasedConfig);
        } else {
            this.retainCountBased(indexSet);
        }
    }

    private void retainTimeBased(IndexSet indexSet, TimeBasedSizeOptimizingStrategyConfig timeBasedConfig) {
        Map<String, Set<String>> deflectorIndices = indexSet.getAllIndexAliases();
        DateTime now = this.clock.nowUTC();
        long cutoffSoft = now.minus((ReadablePeriod)timeBasedConfig.indexLifetimeMin()).getMillis();
        long cutoffHard = now.minus((ReadablePeriod)timeBasedConfig.indexLifetimeMax()).getMillis();
        int removeCount = (int)deflectorIndices.keySet().stream().filter(indexName -> !this.indices.isReopened((String)indexName)).filter(indexName -> !AbstractIndexRetentionStrategy.hasCurrentWriteAlias(indexSet, deflectorIndices, indexName)).filter(indexName -> this.exceedsAgeLimit((String)indexName, cutoffSoft, cutoffHard)).count();
        if (removeCount > 0) {
            String msg = "Running retention for " + removeCount + " aged-out indices.";
            LOG.info(msg);
            this.activityWriter.write(new Activity(msg, IndexRetentionThread.class));
            this.runRetention(indexSet, deflectorIndices, removeCount);
        }
    }

    private boolean exceedsAgeLimit(String indexName, long cutoffSoft, long cutoffHard) {
        Optional<DateTime> closingDate = this.indices.indexClosingDate(indexName);
        if (closingDate.isPresent()) {
            return closingDate.get().isBefore(cutoffSoft + 1L);
        }
        Optional<DateTime> creationDate = this.indices.indexCreationDate(indexName);
        if (creationDate.isPresent()) {
            return creationDate.get().isBefore(cutoffHard + 1L);
        }
        LOG.warn(StringUtils.f("Unable to determine creation or closing dates for Index %s - forcing retention", indexName));
        return true;
    }

    private void retainCountBased(IndexSet indexSet) {
        Map<String, Set<String>> deflectorIndices = indexSet.getAllIndexAliases();
        int indexCount = (int)deflectorIndices.keySet().stream().filter(indexName -> !this.indices.isReopened((String)indexName)).count();
        Optional<Integer> maxIndices = this.getMaxNumberOfIndices(indexSet);
        if (!maxIndices.isPresent()) {
            LOG.warn("No retention strategy configuration found, not running index retention!");
            return;
        }
        if (indexCount <= maxIndices.get()) {
            LOG.debug("Number of indices ({}) lower than limit ({}). Not performing any retention actions.", (Object)indexCount, (Object)maxIndices.get());
            return;
        }
        int removeCount = indexCount - maxIndices.get();
        String msg = "Number of indices (" + indexCount + ") higher than limit (" + maxIndices.get() + "). Running retention for " + removeCount + " indices.";
        LOG.info(msg);
        this.activityWriter.write(new Activity(msg, IndexRetentionThread.class));
        this.runRetention(indexSet, deflectorIndices, removeCount);
    }

    private void runRetention(IndexSet indexSet, Map<String, Set<String>> deflectorIndices, int removeCount) {
        Set orderedIndices = Arrays.stream(indexSet.getManagedIndices()).filter(indexName -> !this.indices.isReopened((String)indexName)).filter(indexName -> !AbstractIndexRetentionStrategy.hasCurrentWriteAlias(indexSet, deflectorIndices, indexName)).sorted((indexName1, indexName2) -> indexSet.extractIndexNumber((String)indexName2).orElse(0).compareTo(indexSet.extractIndexNumber((String)indexName1).orElse(0))).collect(Collectors.toCollection(LinkedHashSet::new));
        LinkedList<String> orderedIndicesDescending = new LinkedList<String>();
        orderedIndices.stream().skip(orderedIndices.size() - removeCount).collect(Collectors.toCollection(LinkedList::new)).descendingIterator().forEachRemaining(orderedIndicesDescending::add);
        String indexNamesAsString = String.join((CharSequence)", ", orderedIndicesDescending);
        String strategyName = this.getClass().getCanonicalName();
        String msg = "Running retention strategy [" + strategyName + "] for indices <" + indexNamesAsString + ">";
        LOG.info(msg);
        this.activityWriter.write(new Activity(msg, IndexRetentionThread.class));
        this.retain(orderedIndicesDescending, indexSet);
    }

    private static boolean hasCurrentWriteAlias(IndexSet indexSet, Map<String, Set<String>> deflectorIndices, String indexName) {
        return deflectorIndices.getOrDefault(indexName, Collections.emptySet()).contains(indexSet.getWriteIndexAlias());
    }
}

