/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.outputs;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.swrve.ratelimitedlogger.RateLimitedLog;
import java.time.Duration;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.graylog2.database.NotFoundException;
import org.graylog2.notifications.Notification;
import org.graylog2.notifications.NotificationService;
import org.graylog2.outputs.DefaultMessageOutput;
import org.graylog2.outputs.MessageOutputFactory;
import org.graylog2.outputs.events.OutputChangedEvent;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.outputs.InsufficientLicenseException;
import org.graylog2.plugin.outputs.MessageOutput;
import org.graylog2.plugin.streams.Output;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.plugin.system.NodeId;
import org.graylog2.streams.OutputService;
import org.graylog2.streams.StreamService;
import org.graylog2.streams.events.StreamsChangedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class OutputRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(OutputRegistry.class);
    private static final Logger RATE_LIMITED_LOG = RateLimitedLog.withRateLimit((Logger)LOG).maxRate(1).every(Duration.ofSeconds(5L)).build();
    private final Cache<String, MessageOutput> runningMessageOutputs;
    private final MessageOutput defaultMessageOutput;
    private final OutputService outputService;
    private final NotificationService notificationService;
    private final NodeId nodeId;
    private final MessageOutputFactory messageOutputFactory;
    private final LoadingCache<String, AtomicInteger> faultCounters;
    private final StreamService streamService;
    private final long faultCountThreshold;
    private final long faultPenaltySeconds;

    @Inject
    public OutputRegistry(@DefaultMessageOutput MessageOutput defaultMessageOutput, OutputService outputService, MessageOutputFactory messageOutputFactory, NotificationService notificationService, NodeId nodeId, EventBus eventBus, StreamService streamService, @Named(value="output_fault_count_threshold") long faultCountThreshold, @Named(value="output_fault_penalty_seconds") long faultPenaltySeconds) {
        this.defaultMessageOutput = defaultMessageOutput;
        this.outputService = outputService;
        this.notificationService = notificationService;
        this.nodeId = nodeId;
        this.messageOutputFactory = messageOutputFactory;
        this.streamService = streamService;
        this.runningMessageOutputs = CacheBuilder.newBuilder().build();
        this.faultCountThreshold = faultCountThreshold;
        this.faultPenaltySeconds = faultPenaltySeconds;
        this.faultCounters = CacheBuilder.newBuilder().expireAfterWrite(this.faultPenaltySeconds, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<String, AtomicInteger>(){

            public AtomicInteger load(String key) throws Exception {
                return new AtomicInteger(0);
            }
        });
        eventBus.register((Object)this);
    }

    @Subscribe
    public void handleOutputChanged(OutputChangedEvent outputChangedEvent) {
        this.removeOutput(outputChangedEvent.outputId());
    }

    @Subscribe
    public void handleStreamsChanged(StreamsChangedEvent streamsChangedEvent) {
        if (streamsChangedEvent.streamIds().isEmpty()) {
            return;
        }
        Set expectedRunningOutputs = this.streamService.loadAllEnabled().stream().flatMap(stream -> stream.getOutputs().stream()).map(Output::getId).collect(Collectors.toSet());
        Set currentlyRunningOutputs = this.runningMessageOutputs.asMap().keySet();
        Sets.difference(currentlyRunningOutputs, expectedRunningOutputs).forEach(this::removeOutput);
    }

    @Nullable
    public MessageOutput getOutputForIdAndStream(String id, Stream stream) {
        block8: {
            AtomicInteger faultCount;
            try {
                faultCount = (AtomicInteger)this.faultCounters.get((Object)id);
            }
            catch (ExecutionException e) {
                LOG.error("Unable to retrieve output fault counter", (Throwable)e);
                return null;
            }
            try {
                if ((long)faultCount.get() < this.faultCountThreshold) {
                    return (MessageOutput)this.runningMessageOutputs.get((Object)id, this.loadForIdAndStream(id, stream));
                }
            }
            catch (UncheckedExecutionException | ExecutionException e) {
                if (e.getCause() instanceof NotFoundException || e.getCause() instanceof IllegalArgumentException) {
                    RATE_LIMITED_LOG.debug("Unable to fetch output <{}> for stream <{}/{}>: {}", new Object[]{id, stream.getTitle(), stream.getId(), e.getMessage()});
                }
                int number = faultCount.addAndGet(1);
                Throwable throwable = e.getCause();
                if (throwable instanceof InsufficientLicenseException) {
                    InsufficientLicenseException licenseException = (InsufficientLicenseException)throwable;
                    LOG.error("Unable to fetch output {}, fault #{}: {}", new Object[]{id, number, licenseException.getLocalizedMessage()});
                } else {
                    LOG.error("Unable to fetch output " + id + ", fault #" + number, e);
                }
                if ((long)number < this.faultCountThreshold) break block8;
                LOG.error("Output {} has crossed threshold of {} faults in {} seconds. Disabling for {} seconds.", new Object[]{id, this.faultCountThreshold, this.faultPenaltySeconds, this.faultPenaltySeconds});
                Notification notification = this.notificationService.buildNow().addType(Notification.Type.OUTPUT_DISABLED).addSeverity(Notification.Severity.NORMAL).addNode(this.nodeId.getNodeId()).addDetail("outputId", id).addDetail("streamId", stream.getId()).addDetail("streamTitle", stream.getTitle()).addDetail("faultCount", number).addDetail("faultCountThreshold", this.faultCountThreshold).addDetail("faultPenaltySeconds", this.faultPenaltySeconds);
                this.notificationService.publishIfFirst(notification);
            }
        }
        return null;
    }

    public Callable<MessageOutput> loadForIdAndStream(final String id, final Stream stream) {
        return new Callable<MessageOutput>(){

            @Override
            public MessageOutput call() throws Exception {
                Stream dbStream = OutputRegistry.this.streamService.load(stream.getId());
                if (dbStream.getOutputs().stream().map(Output::getId).anyMatch(id::equalsIgnoreCase)) {
                    Output output = OutputRegistry.this.outputService.load(id);
                    return OutputRegistry.this.launchOutput(output, stream);
                }
                throw new IllegalArgumentException("Output not assigned to stream");
            }
        };
    }

    protected MessageOutput launchOutput(Output output, Stream stream) throws Exception {
        MessageOutput messageOutput = this.messageOutputFactory.fromStreamOutput(output, stream, new Configuration(output.getConfiguration()));
        if (messageOutput == null) {
            throw new IllegalArgumentException("Failed to instantiate MessageOutput from Output: " + output);
        }
        messageOutput.initialize();
        return messageOutput;
    }

    @VisibleForTesting
    protected Map<String, MessageOutput> getRunningMessageOutputs() {
        return ImmutableMap.copyOf((Map)this.runningMessageOutputs.asMap());
    }

    public Set<MessageOutput> getMessageOutputs() {
        return ImmutableSet.builder().addAll(this.runningMessageOutputs.asMap().values()).add((Object)this.defaultMessageOutput).build();
    }

    public void removeOutput(Output output) {
        this.removeOutput(output.getId());
    }

    private void removeOutput(String outputId) {
        MessageOutput messageOutput = (MessageOutput)this.runningMessageOutputs.getIfPresent((Object)outputId);
        if (messageOutput != null) {
            messageOutput.stop();
        }
        this.runningMessageOutputs.invalidate((Object)outputId);
        this.faultCounters.invalidate((Object)outputId);
    }
}

