/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system;

import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Optional;
import javax.inject.Inject;
import javax.validation.constraints.NotEmpty;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.Configuration;
import org.graylog2.configuration.ExposedConfiguration;
import org.graylog2.configuration.retrieval.SingleConfigurationValueRetriever;
import org.graylog2.shared.rest.resources.RestResource;

@RequiresAuthentication
@Api(value="System/Configuration", description="Read-only access to configuration settings")
@Path(value="/system/configuration")
@Produces(value={"application/json"})
public class ConfigurationResource
extends RestResource {
    private final Configuration configuration;
    private final SingleConfigurationValueRetriever singleConfigurationValueRetriever;

    @Inject
    public ConfigurationResource(Configuration configuration, SingleConfigurationValueRetriever singleConfigurationValueRetriever) {
        this.configuration = configuration;
        this.singleConfigurationValueRetriever = singleConfigurationValueRetriever;
    }

    @GET
    @Timed
    @ApiOperation(value="Get relevant configuration settings and their values")
    public ExposedConfiguration getRelevant() {
        return ExposedConfiguration.create(this.configuration);
    }

    @GET
    @Path(value="/{name}")
    @Timed
    @ApiOperation(value="Get relevant configuration setting value")
    public Response getRelevantByName(@ApiParam(name="name", required=true) @PathParam(value="name") @NotEmpty String configSettingName) {
        ExposedConfiguration conf = ExposedConfiguration.create(this.configuration);
        Optional<Object> value = this.singleConfigurationValueRetriever.retrieveSingleValue(conf, configSettingName);
        return value.map(v -> Response.ok((Object)new SingleValue(v)).build()).orElse(Response.status((Response.Status)Response.Status.NOT_FOUND).build());
    }

    public record SingleValue(@JsonProperty(value="value") Object value) {
    }
}

