/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.security;

import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;

@Singleton
public class SafeClasses {
    private final Set<String> prefixes;

    public static SafeClasses allGraylogInternal() {
        return new SafeClasses(Set.of("org.graylog.", "org.graylog2."));
    }

    @Inject
    public SafeClasses(@Named(value="safe_classes") @Nonnull Set<String> prefixes) {
        this.prefixes = Objects.requireNonNull(prefixes);
    }

    public boolean isSafeToLoad(String className) {
        return this.prefixes.stream().anyMatch(className::startsWith);
    }
}

