/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.plugins;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.inject.Injector;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.graylog2.plugin.Plugin;
import org.graylog2.plugin.PluginBootstrapConfig;
import org.graylog2.plugin.PluginMetaData;
import org.graylog2.plugin.PluginModule;
import org.graylog2.plugin.PreflightCheckModule;
import org.graylog2.shared.SuppressForbidden;
import org.graylog2.shared.plugins.ChainingClassLoader;
import org.graylog2.shared.plugins.PluginProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginLoader {
    private static final Logger LOG = LoggerFactory.getLogger(PluginLoader.class);
    private static final String[] PLUGIN_FILE_EXTENSIONS = new String[]{"jar", "JAR"};
    private final File pluginDir;
    protected final ChainingClassLoader classLoader;

    public PluginLoader(File pluginDir, ChainingClassLoader classLoader) {
        this.pluginDir = Objects.requireNonNull(pluginDir);
        this.classLoader = Objects.requireNonNull(classLoader);
        this.loadPluginJars();
    }

    public Set<PluginBootstrapConfig> loadPluginBootstrapConfigs() {
        return ImmutableSet.copyOf(ServiceLoader.load(PluginBootstrapConfig.class, this.classLoader));
    }

    public Set<Plugin> loadPlugins(Injector injector) {
        return ImmutableSortedSet.orderedBy((Comparator)new PluginComparator()).addAll(Iterables.transform(this.loadJarPlugins(), (Function)new PluginAdapterFunction(injector))).addAll(Iterables.transform(this.loadClassPathPlugins(), (Function)new PluginAdapterFunction(injector))).build();
    }

    protected Iterable<Plugin> loadClassPathPlugins() {
        return ServiceLoader.load(Plugin.class);
    }

    protected Iterable<Plugin> loadJarPlugins() {
        return ImmutableSet.copyOf(ServiceLoader.load(Plugin.class, this.classLoader));
    }

    @SuppressForbidden(value="Deliberate invocation of URL#getFile()")
    private void loadPluginJars() {
        if (!this.pluginDir.exists()) {
            LOG.warn("Plugin directory {} does not exist, not loading plugins.", (Object)this.pluginDir.getAbsolutePath());
            return;
        }
        if (!this.pluginDir.isDirectory()) {
            LOG.warn("Path {} is not a directory, cannot load plugins.", (Object)this.pluginDir);
            return;
        }
        LOG.debug("Scanning directory <{}> for plugins...", (Object)this.pluginDir.getAbsolutePath());
        Collection files = FileUtils.listFiles((File)this.pluginDir, (String[])PLUGIN_FILE_EXTENSIONS, (boolean)false);
        LOG.debug("Loading [{}] plugins", (Object)files.size());
        List<URL> urls = files.stream().filter(File::isFile).map(jar -> {
            try {
                LOG.debug("Loading <" + jar.getAbsolutePath() + ">");
                return jar.toURI().toURL();
            }
            catch (MalformedURLException e) {
                LOG.error("Cannot open JAR file for discovering plugins", (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).toList();
        ArrayList sharedClassLoaderUrls = new ArrayList();
        urls.forEach(url -> {
            PluginProperties properties = PluginProperties.fromJarFile(url.getFile());
            if (properties.isIsolated()) {
                LOG.debug("Creating isolated class loader for <{}>", url);
                this.classLoader.addClassLoader(URLClassLoader.newInstance(new URL[]{url}));
            } else {
                LOG.debug("Using shared class loader for <{}>", url);
                sharedClassLoaderUrls.add(url);
            }
        });
        if (!sharedClassLoaderUrls.isEmpty()) {
            LOG.debug("Creating shared class loader for {} plugins: {}", (Object)sharedClassLoaderUrls.size(), sharedClassLoaderUrls);
            this.classLoader.addClassLoader(URLClassLoader.newInstance(sharedClassLoaderUrls.toArray(new URL[0])));
        }
    }

    public static class PluginComparator
    implements Comparator<Plugin> {
        @Override
        public int compare(Plugin o1, Plugin o2) {
            return ComparisonChain.start().compare((Comparable)((Object)o1.metadata().getUniqueId()), (Comparable)((Object)o2.metadata().getUniqueId())).compare((Comparable)((Object)o1.metadata().getName()), (Comparable)((Object)o2.metadata().getName())).compare((Comparable)o1.metadata().getVersion(), (Comparable)o2.metadata().getVersion()).result();
        }
    }

    protected class PluginAdapterFunction
    implements Function<Plugin, Plugin> {
        private final Injector injector;

        public PluginAdapterFunction(Injector injector) {
            this.injector = injector;
        }

        public Plugin apply(Plugin input) {
            this.injector.injectMembers((Object)input);
            return new PluginAdapter(input);
        }
    }

    public static class PluginAdapter
    implements Plugin {
        private final Plugin plugin;

        public PluginAdapter(Plugin plugin) {
            this.plugin = (Plugin)Preconditions.checkNotNull((Object)plugin);
        }

        @Override
        public PluginMetaData metadata() {
            return this.plugin.metadata();
        }

        @Override
        public Collection<PluginModule> modules() {
            return this.plugin.modules();
        }

        @Override
        public Collection<PreflightCheckModule> preflightCheckModules() {
            return this.plugin.preflightCheckModules();
        }

        public String getPluginClassName() {
            return this.plugin.getClass().getCanonicalName();
        }

        public int hashCode() {
            return Objects.hash(this.plugin.metadata().getUniqueId());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Plugin) {
                Plugin that = (Plugin)obj;
                return Objects.equals(this.metadata().getUniqueId(), that.metadata().getUniqueId());
            }
            return false;
        }

        public String toString() {
            PluginMetaData metadata = this.plugin.metadata();
            return metadata.getName() + " " + metadata.getVersion() + " [" + metadata.getUniqueId() + "]";
        }
    }
}

