/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.integrations.dataadapters;

import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.inject.assistedinject.Assisted;
import jakarta.inject.Inject;
import jakarta.validation.constraints.NotEmpty;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.validator.routines.InetAddressValidator;
import org.graylog.integrations.dataadapters.AutoValue_GreyNoiseCommunityIpLookupAdapter_Config;
import org.graylog.plugins.threatintel.tools.AdapterDisabledException;
import org.graylog2.plugin.lookup.LookupCachePurge;
import org.graylog2.plugin.lookup.LookupDataAdapter;
import org.graylog2.plugin.lookup.LookupDataAdapterConfiguration;
import org.graylog2.plugin.lookup.LookupResult;
import org.graylog2.security.encryption.EncryptedValue;
import org.graylog2.security.encryption.EncryptedValueService;
import org.graylog2.utilities.ReservedIpChecker;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class GreyNoiseCommunityIpLookupAdapter
extends LookupDataAdapter {
    public static final String ADAPTER_NAME = "GreyNoise Community IP Lookup";
    protected static final String GREYNOISE_COMMUNITY_ENDPOINT = "https://api.greynoise.io/v3/community";
    private static final Logger LOG = LoggerFactory.getLogger(GreyNoiseCommunityIpLookupAdapter.class);
    private static final List<Object> EXCLUDED_FIELDS = Collections.singletonList("message");
    private static final String USER_AGENT = "Graylog";
    private static final String ACCEPT_TYPE = "application/json";
    private static final String METHOD = "GET";
    private final EncryptedValueService encryptedValueService;
    private final Config config;
    private final OkHttpClient okHttpClient;

    @Inject
    public GreyNoiseCommunityIpLookupAdapter(@Assisted(value="id") String id, @Assisted(value="name") String name, @Assisted LookupDataAdapterConfiguration config, MetricRegistry metricRegistry, EncryptedValueService encryptedValueService, OkHttpClient okHttpClient) {
        super(id, name, config, metricRegistry);
        this.config = (Config)config;
        this.encryptedValueService = encryptedValueService;
        this.okHttpClient = okHttpClient;
    }

    @Override
    protected void doStart() throws Exception {
        throw new AdapterDisabledException("The GreyNoise Community IP Lookup Data Adapter is no longer supported. This Data Adapter should be deleted.");
    }

    @Override
    protected void doStop() {
    }

    @Override
    public Duration refreshInterval() {
        return Duration.ZERO;
    }

    @Override
    protected void doRefresh(LookupCachePurge cachePurge) {
    }

    @Override
    public void set(Object key, Object value) {
    }

    @Override
    protected LookupResult doGet(Object ipAddress) {
        return LookupResult.withError("GreyNoise Community IP Lookup Data Adapter is deprecated and lookups can no longer be performed.");
    }

    protected LookupResult doDoGet(Object ipAddress) {
        LookupResult result;
        Optional<Request> request = this.createRequest(ipAddress);
        if (!request.isPresent()) {
            return LookupResult.withError();
        }
        try (Response response = this.okHttpClient.newCall(request.get()).execute();){
            result = GreyNoiseCommunityIpLookupAdapter.parseResponse(response);
        }
        catch (IOException e) {
            LOG.error("an error occurred while retrieving GreyNoise IP data. {}", (Object)e.getMessage(), (Object)e);
            result = LookupResult.withError();
        }
        return result;
    }

    @VisibleForTesting
    Optional<Request> createRequest(Object ipAddress) {
        Optional<String> ipString = this.getValidIpString(ipAddress);
        if (!ipString.isPresent()) {
            return Optional.empty();
        }
        String apiToken = this.encryptedValueService.decrypt(this.config.apiToken());
        if (apiToken == null || apiToken.trim().isEmpty()) {
            String error = String.format(Locale.ROOT, "[%s] requires a non-null API Token", ADAPTER_NAME);
            throw new IllegalArgumentException(error);
        }
        Request request = new Request.Builder().url(String.join((CharSequence)"/", GREYNOISE_COMMUNITY_ENDPOINT, ipString.get())).method(METHOD, null).addHeader("Accept", ACCEPT_TYPE).addHeader("User-Agent", USER_AGENT).addHeader("key", apiToken).build();
        return Optional.of(request);
    }

    private Optional<String> getValidIpString(Object ipAddress) {
        String ipString;
        String string = ipString = ipAddress == null ? "" : ipAddress.toString();
        if (ipString.trim().isEmpty()) {
            String error = String.format(Locale.ROOT, "'%s' requires an IP address to perform Lookup", ADAPTER_NAME);
            throw new IllegalArgumentException(error);
        }
        String validIpAddress = null;
        InetAddressValidator validator = InetAddressValidator.getInstance();
        if (validator.isValidInet6Address(ipString)) {
            LOG.warn("'{}' is an IPv6 Address.  '{}' does not support IPv6 Addresses", ipAddress, (Object)ADAPTER_NAME);
        } else if (!validator.isValidInet4Address(ipString)) {
            LOG.error("'{}' is not a valid IPv4 Address", (Object)ipString);
        } else if (ReservedIpChecker.getInstance().isReservedIpAddress(ipString)) {
            LOG.error("'{}' is a Reserved address", ipAddress);
        } else {
            validIpAddress = ipString;
        }
        return Optional.ofNullable(validIpAddress);
    }

    @VisibleForTesting
    static LookupResult parseResponse(Response response) {
        LookupResult result = response.isSuccessful() ? GreyNoiseCommunityIpLookupAdapter.createSuccessfulResult(response) : GreyNoiseCommunityIpLookupAdapter.createUnsuccessfulResult(response);
        return result;
    }

    private static LookupResult createUnsuccessfulResult(Response response) {
        Map<Object, Object> allValues = GreyNoiseCommunityIpLookupAdapter.getResponseValueMap(response);
        boolean hasError = response.code() != 404;
        return LookupResult.withoutTTL().multiValue(allValues).hasError(hasError).build();
    }

    private static LookupResult createSuccessfulResult(Response response) {
        Map<Object, Object> allValues = GreyNoiseCommunityIpLookupAdapter.getResponseValueMap(response);
        return LookupResult.withoutTTL().multiValue(allValues).build();
    }

    private static Map<Object, Object> getResponseValueMap(Response response) {
        Map values;
        try {
            if (response.body() == null) {
                values = Collections.emptyMap();
            } else {
                ObjectMapper mapper = new ObjectMapper();
                TypeReference<Map<Object, Object>> ref = new TypeReference<Map<Object, Object>>(){};
                values = (Map)mapper.readValue(response.body().byteStream(), (TypeReference)ref);
            }
        }
        catch (IOException e2) {
            LOG.error("An error occurred while parsing parsing Lookup result. {}", (Object)e2.getMessage(), (Object)e2);
            values = Collections.emptyMap();
        }
        return values.entrySet().stream().filter(e -> !EXCLUDED_FIELDS.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @JsonAutoDetect
    @JsonDeserialize(builder=Builder.class)
    @JsonTypeName(value="GreyNoise Community IP Lookup")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @AutoValue
    public static abstract class Config
    implements LookupDataAdapterConfiguration {
        @JsonProperty(value="api_token")
        @NotEmpty
        public abstract EncryptedValue apiToken();

        public static Builder builder() {
            return new AutoValue_GreyNoiseCommunityIpLookupAdapter_Config.Builder();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            @JsonCreator
            public static Builder create() {
                return Config.builder();
            }

            @JsonProperty(value="type")
            public abstract Builder type(String var1);

            @JsonProperty(value="api_token")
            public abstract Builder apiToken(EncryptedValue var1);

            public abstract Config build();
        }
    }

    public static class Descriptor
    extends LookupDataAdapter.Descriptor<Config> {
        public Descriptor() {
            super(GreyNoiseCommunityIpLookupAdapter.ADAPTER_NAME, Config.class);
        }

        @Override
        public Config defaultConfiguration() {
            return Config.builder().type(GreyNoiseCommunityIpLookupAdapter.ADAPTER_NAME).apiToken(EncryptedValue.createUnset()).build();
        }
    }

    public static interface Factory
    extends LookupDataAdapter.Factory<GreyNoiseCommunityIpLookupAdapter> {
        @Override
        public GreyNoiseCommunityIpLookupAdapter create(@Assisted(value="id") String var1, @Assisted(value="name") String var2, LookupDataAdapterConfiguration var3);

        @Override
        public Descriptor getDescriptor();
    }
}

