/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.integrations.migrations;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.google.auto.value.AutoValue;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Updates;
import com.mongodb.client.result.UpdateResult;
import jakarta.inject.Inject;
import java.time.ZonedDateTime;
import org.bson.conversions.Bson;
import org.graylog.integrations.migrations.AutoValue_V20220622071600_MigratePagerDutyV1_MigrationCompletion;
import org.graylog2.database.MongoConnection;
import org.graylog2.migrations.Migration;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V20220622071600_MigratePagerDutyV1
extends Migration {
    private static final Logger LOG = LoggerFactory.getLogger(V20220622071600_MigratePagerDutyV1.class);
    private static final String COLLECTION_NAME = "event_notifications";
    private static final String PAGER_DUTY_V1 = "pagerduty-notification-v1";
    private static final String TYPE_FIELD = "config.type";
    private final MongoConnection mongoConnection;
    private final ClusterConfigService clusterConfigService;

    @Inject
    public V20220622071600_MigratePagerDutyV1(MongoConnection mongoConnection, ClusterConfigService clusterConfigService) {
        this.mongoConnection = mongoConnection;
        this.clusterConfigService = clusterConfigService;
    }

    @Override
    public ZonedDateTime createdAt() {
        return ZonedDateTime.parse("2022-06-22t07:16Z");
    }

    @Override
    public void upgrade() {
        MigrationCompletion completion = this.clusterConfigService.get(MigrationCompletion.class);
        if (completion != null) {
            LOG.debug("Migration was already completed");
            return;
        }
        MongoCollection collection = this.mongoConnection.getMongoDatabase().getCollection(COLLECTION_NAME);
        LOG.info("Updating '{}' collection.", (Object)COLLECTION_NAME);
        Bson v1Filter = Filters.eq((String)TYPE_FIELD, (Object)PAGER_DUTY_V1);
        Bson v2Update = Updates.set((String)TYPE_FIELD, (Object)"pagerduty-notification-v2");
        LOG.info("Updating {} from {} to {}", new Object[]{TYPE_FIELD, PAGER_DUTY_V1, "pagerduty-notification-v2"});
        UpdateResult updateTypeResult = collection.updateMany(v1Filter, v2Update);
        LOG.info("Update result: {}", (Object)updateTypeResult);
        this.clusterConfigService.write(MigrationCompletion.create());
    }

    @JsonAutoDetect
    @AutoValue
    public static abstract class MigrationCompletion {
        @JsonCreator
        public static MigrationCompletion create() {
            return new AutoValue_V20220622071600_MigratePagerDutyV1_MigrationCompletion();
        }
    }
}

