/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.integrations.notifications.types.microsoftteams;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import jakarta.validation.constraints.NotBlank;
import java.net.URI;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.graylog.events.contentpack.entities.EventNotificationConfigEntity;
import org.graylog.events.event.EventDto;
import org.graylog.events.notifications.EventNotificationConfig;
import org.graylog.events.notifications.EventNotificationExecutionJob;
import org.graylog.integrations.notifications.types.microsoftteams.AutoValue_TeamsEventNotificationConfig;
import org.graylog.integrations.notifications.types.microsoftteams.TeamsEventNotificationConfigEntity;
import org.graylog.scheduler.JobTriggerData;
import org.graylog2.contentpacks.EntityDescriptorIds;
import org.graylog2.contentpacks.model.entities.references.ValueReference;
import org.graylog2.plugin.rest.ValidationResult;
import org.joda.time.DateTimeZone;

@JsonTypeName(value="teams-notification-v1")
@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class TeamsEventNotificationConfig
implements EventNotificationConfig {
    public static final String TYPE_NAME = "teams-notification-v1";
    private static final Pattern TEAMS_PATTERN = Pattern.compile("https://.*.webhook.office.com/");
    private static final String DEFAULT_HEX_COLOR = "#ff0500";
    private static final String DEFAULT_CUSTOM_MESSAGE = "Graylog Teams Notification";
    private static final long DEFAULT_BACKLOG_SIZE = 0L;
    private static final DateTimeZone DEFAULT_TIME_ZONE = DateTimeZone.UTC;
    static final String INVALID_BACKLOG_ERROR_MESSAGE = "Backlog size cannot be less than zero";
    static final String INVALID_WEBHOOK_ERROR_MESSAGE = "Specified Webhook URL is not a valid URL";
    static final String INVALID_TEAMS_URL_ERROR_MESSAGE = "Specified Webhook URL is not a valid Teams URL";
    static final String WEB_HOOK_URL = "https://teams.webhook.office.com/services/xxxx/xxxxxxxxxxxxxxxxxxx";
    static final String FIELD_WEBHOOK_URL = "webhook_url";
    static final String TEAMS_CUSTOM_MESSAGE = "custom_message";
    static final String TEAMS_ICON_URL = "icon_url";
    static final String TEAMS_BACKLOG_SIZE = "backlog_size";
    static final String TEAMS_COLOR = "color";
    static final String TEAMS_TIME_ZONE = "time_zone";

    @JsonProperty(value="backlog_size")
    public abstract long backlogSize();

    @JsonProperty(value="color")
    @NotBlank
    public abstract String color();

    @JsonProperty(value="webhook_url")
    @NotBlank
    public abstract String webhookUrl();

    @JsonProperty(value="custom_message")
    public abstract String customMessage();

    @JsonProperty(value="icon_url")
    @Nullable
    public abstract String iconUrl();

    @JsonProperty(value="time_zone")
    public abstract DateTimeZone timeZone();

    @Override
    @JsonIgnore
    public JobTriggerData toJobTriggerData(EventDto dto) {
        return EventNotificationExecutionJob.Data.builder().eventDto(dto).build();
    }

    public static Builder builder() {
        return Builder.create();
    }

    @Override
    @JsonIgnore
    public ValidationResult validate() {
        ValidationResult validation = new ValidationResult();
        try {
            URI webhookUri = new URI(this.webhookUrl());
            if (webhookUri.getHost().toLowerCase(Locale.ROOT).contains("office") && !TEAMS_PATTERN.matcher(this.webhookUrl()).find()) {
                validation.addError(FIELD_WEBHOOK_URL, INVALID_TEAMS_URL_ERROR_MESSAGE);
            }
        }
        catch (Exception ex) {
            validation.addError(FIELD_WEBHOOK_URL, INVALID_WEBHOOK_ERROR_MESSAGE);
        }
        if (this.backlogSize() < 0L) {
            validation.addError(TEAMS_BACKLOG_SIZE, INVALID_BACKLOG_ERROR_MESSAGE);
        }
        return validation;
    }

    @Override
    public EventNotificationConfigEntity toContentPackEntity(EntityDescriptorIds entityDescriptorIds) {
        return TeamsEventNotificationConfigEntity.builder().color(ValueReference.of(this.color())).webhookUrl(ValueReference.of(this.webhookUrl())).customMessage(ValueReference.of(this.customMessage())).iconUrl(ValueReference.of(this.iconUrl())).timeZone(ValueReference.of(this.timeZone().getID())).build();
    }

    @AutoValue.Builder
    public static abstract class Builder
    implements EventNotificationConfig.Builder<Builder> {
        @JsonCreator
        public static Builder create() {
            return new AutoValue_TeamsEventNotificationConfig.Builder().type(TeamsEventNotificationConfig.TYPE_NAME).color(TeamsEventNotificationConfig.DEFAULT_HEX_COLOR).webhookUrl(TeamsEventNotificationConfig.WEB_HOOK_URL).customMessage(TeamsEventNotificationConfig.DEFAULT_CUSTOM_MESSAGE).backlogSize(0L).timeZone(DEFAULT_TIME_ZONE);
        }

        @JsonProperty(value="color")
        public abstract Builder color(String var1);

        @JsonProperty(value="webhook_url")
        public abstract Builder webhookUrl(String var1);

        @JsonProperty(value="custom_message")
        public abstract Builder customMessage(String var1);

        @JsonProperty(value="icon_url")
        public abstract Builder iconUrl(String var1);

        @JsonProperty(value="backlog_size")
        public abstract Builder backlogSize(long var1);

        @JsonProperty(value="time_zone")
        public abstract Builder timeZone(DateTimeZone var1);

        public abstract TeamsEventNotificationConfig build();
    }
}

