/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.arrays;

import com.fasterxml.jackson.databind.node.ValueNode;
import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.AbstractFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.graylog.plugins.pipelineprocessor.rulebuilder.RuleBuilderFunctionGroup;

public class StringArrayAdd
extends AbstractFunction<List<String>> {
    public static final String NAME = "string_array_add";
    private static final Class<List<String>> LIST_RETURN_TYPE = new TypeToken<List<String>>(){}.getRawType();
    private final ParameterDescriptor<Object, List<String>> elementsParam = ParameterDescriptor.object("elements", LIST_RETURN_TYPE).transform(this::transformToList).description("The input string array, may be null").build();
    private final ParameterDescriptor<Object, List<String>> valueParam = ParameterDescriptor.object("value", LIST_RETURN_TYPE).transform(this::transformToList).description("The string (or string array) value to add to the array").build();
    private final ParameterDescriptor<Boolean, Boolean> onlyUniqueParam = ParameterDescriptor.bool("only_unique").optional().description("Only add elements if not already present").build();

    private List<String> transformToList(Object value) {
        if (value instanceof Collection) {
            return ((Collection)value).stream().map(StringArrayAdd::convertValue).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return value == null ? Collections.emptyList() : Collections.singletonList(value.toString());
    }

    private static String convertValue(Object o) {
        if (o instanceof ValueNode) {
            ValueNode node = (ValueNode)o;
            return node.textValue();
        }
        return o.toString();
    }

    @Override
    public List<String> evaluate(FunctionArgs args, EvaluationContext context) {
        ArrayList<String> elements = new ArrayList<String>(this.elementsParam.optional(args, context).orElse(Collections.emptyList()));
        List valueArray = this.valueParam.optional(args, context).orElse(Collections.emptyList());
        boolean onlyUnique = this.onlyUniqueParam.optional(args, context).orElse(false);
        if (onlyUnique) {
            valueArray.stream().filter(v -> !elements.contains(v)).forEach(elements::add);
            return elements;
        }
        elements.addAll(valueArray.stream().map(Object::toString).toList());
        return elements;
    }

    @Override
    public FunctionDescriptor<List<String>> descriptor() {
        return FunctionDescriptor.builder().name(NAME).pure(true).returnType(LIST_RETURN_TYPE).params((ImmutableList<ParameterDescriptor>)ImmutableList.of(this.elementsParam, this.valueParam, this.onlyUniqueParam)).description("Adds the specified string (or string array) value to the supplied string array.").ruleBuilderEnabled().ruleBuilderName("Add to array").ruleBuilderTitle("Add '${elements}' to array '${value}'").ruleBuilderFunctionGroup(RuleBuilderFunctionGroup.ARRAY).build();
    }
}

