/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.hashing;

import com.google.common.collect.ImmutableList;
import java.util.Locale;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.AbstractFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.graylog.plugins.pipelineprocessor.rulebuilder.RuleBuilderFunctionGroup;

abstract class SingleArgStringFunction
extends AbstractFunction<String> {
    private final ParameterDescriptor<String, String> valueParam = ParameterDescriptor.string("value").ruleBuilderVariable().description("The value to hash").build();

    SingleArgStringFunction() {
    }

    @Override
    public String evaluate(FunctionArgs args, EvaluationContext context) {
        String value = this.valueParam.required(args, context);
        return this.getDigest(value);
    }

    protected abstract String getDigest(String var1);

    protected abstract String getName();

    protected String description() {
        return this.getName().toUpperCase(Locale.ENGLISH) + " hash of the string";
    }

    protected String getRuleBuilderName() {
        return "Generate " + this.getName().toUpperCase(Locale.ENGLISH) + " hash";
    }

    protected String getRuleBuilderTitle() {
        return "Generate " + this.getName().toUpperCase(Locale.ENGLISH) + " hash of '${value}'";
    }

    @Override
    public FunctionDescriptor<String> descriptor() {
        return FunctionDescriptor.builder().name(this.getName()).returnType(String.class).params((ImmutableList<ParameterDescriptor>)ImmutableList.of(this.valueParam)).description(this.description()).ruleBuilderEnabled().ruleBuilderName(this.getRuleBuilderName()).ruleBuilderTitle(this.getRuleBuilderTitle()).ruleBuilderFunctionGroup(RuleBuilderFunctionGroup.HASH).build();
    }
}

