/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.messages;

import com.google.common.collect.ImmutableList;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.AbstractFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.graylog.plugins.pipelineprocessor.rulebuilder.RuleBuilderFunctionGroup;
import org.graylog2.plugin.Message;

public class GetField
extends AbstractFunction<Object> {
    public static final String NAME = "get_field";
    public static final String FIELD = "field";
    private final ParameterDescriptor<String, String> fieldParam = ParameterDescriptor.string("field").description("The field to get").build();
    private final ParameterDescriptor<Message, Message> messageParam = ParameterDescriptor.type("message", Message.class).optional().description("The message to use, defaults to '$message'").ruleBuilderVariable().build();

    @Override
    public Object evaluate(FunctionArgs args, EvaluationContext context) {
        String field = this.fieldParam.required(args, context);
        Message message = this.messageParam.optional(args, context).orElse(context.currentMessage());
        return message.getField(field);
    }

    @Override
    public FunctionDescriptor<Object> descriptor() {
        return FunctionDescriptor.builder().name(NAME).returnType(Object.class).params((ImmutableList<ParameterDescriptor>)ImmutableList.of(this.fieldParam, this.messageParam)).description("Retrieves the value for a field").ruleBuilderEnabled().ruleBuilderName("Get field value").ruleBuilderTitle("Retrieve value for field '${field}'").ruleBuilderFunctionGroup(RuleBuilderFunctionGroup.MESSAGE).build();
    }
}

