/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.messages;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.regex.Pattern;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.AbstractFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.graylog.plugins.pipelineprocessor.rulebuilder.RuleBuilderFunctionGroup;
import org.graylog2.plugin.Message;

public class RemoveMultipleFields
extends AbstractFunction<Void> {
    public static final String NAME = "remove_multiple_fields";
    private static final String REGEX_PATTERN = "pattern";
    private static final String LIST_OF_NAMES = "names";
    private final ParameterDescriptor<String, Pattern> regexParam = ParameterDescriptor.string("pattern", Pattern.class).optional().transform(Pattern::compile).description("A regex specifying field names to be removed").build();
    private final ParameterDescriptor<List, List> namesParam = ParameterDescriptor.type("names", List.class).optional().description("A list of field names to be removed").build();
    private final ParameterDescriptor<Message, Message> messageParam = ParameterDescriptor.type("message", Message.class).optional().description("The message to use, defaults to '$message'").build();

    @Override
    public Void evaluate(FunctionArgs args, EvaluationContext context) {
        Message message = this.messageParam.optional(args, context).orElse(context.currentMessage());
        if (this.regexParam.optional(args, context).isPresent()) {
            this.removeRegex(message, this.regexParam.optional(args, context).get());
        }
        if (this.namesParam.optional(args, context).isPresent()) {
            this.removeNames(message, this.namesParam.optional(args, context).get());
        }
        return null;
    }

    private void removeRegex(Message message, Pattern pattern) {
        message.getFieldNames().stream().filter(name -> pattern.matcher((CharSequence)name).matches()).toList().forEach(message::removeField);
    }

    private void removeNames(Message message, List names) {
        for (Object name : names) {
            message.removeField(String.valueOf(name));
        }
    }

    @Override
    public FunctionDescriptor<Void> descriptor() {
        return FunctionDescriptor.builder().name(NAME).returnType(Void.class).params((ImmutableList<ParameterDescriptor>)ImmutableList.of(this.regexParam, this.namesParam, this.messageParam)).description("Removes the specified field(s) from message, unless the field name is reserved. If no specific message is provided, it uses the currently processed message.").ruleBuilderEnabled().ruleBuilderName("Remove field - multiple").ruleBuilderTitle("Remove multiple fields by<#if pattern??> regex '${pattern}'</#if><#if pattern?? && names??> or</#if><#if names??> name list '${names}'</#if>").ruleBuilderFunctionGroup(RuleBuilderFunctionGroup.MESSAGE).build();
    }
}

