/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.simulator;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableSortedSet;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.graylog.plugins.pipelineprocessor.ast.Pipeline;
import org.graylog.plugins.pipelineprocessor.ast.Rule;
import org.graylog.plugins.pipelineprocessor.ast.Stage;
import org.graylog.plugins.pipelineprocessor.processors.ConfigurationStateUpdater;
import org.graylog.plugins.pipelineprocessor.processors.PipelineInterpreter;
import org.graylog.plugins.pipelineprocessor.simulator.PipelineInterpreterTracer;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.MessageFactory;
import org.graylog2.shared.messageq.noop.NoopMessageQueueAcknowledger;
import org.graylog2.shared.metrics.MetricRegistryFactory;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class RuleSimulator {
    private final ConfigurationStateUpdater configurationStateUpdater;
    private final ObjectMapper objectMapper;
    private final MessageFactory messageFactory;

    @Inject
    public RuleSimulator(ConfigurationStateUpdater configurationStateUpdater, ObjectMapper objectMapper, MessageFactory messageFactory) {
        this.configurationStateUpdater = configurationStateUpdater;
        this.objectMapper = objectMapper;
        this.messageFactory = messageFactory;
    }

    public Message simulate(Rule rule, Message message) {
        Stage stage = Stage.builder().stage(0).ruleReferences(Collections.emptyList()).match(Stage.Match.PASS).build();
        stage.setRules(List.of(rule));
        Pipeline pipeline = Pipeline.builder().stages((SortedSet<Stage>)ImmutableSortedSet.of((Comparable)stage)).name("dummyPipeline").id(UUID.randomUUID().toString()).build();
        stage.setPipeline(pipeline);
        PipelineInterpreter pipelineInterpreter = new PipelineInterpreter(new NoopMessageQueueAcknowledger(), MetricRegistryFactory.create(), this.configurationStateUpdater);
        PipelineInterpreterTracer pipelineInterpreterTracer = new PipelineInterpreterTracer();
        pipelineInterpreter.evaluateStage(stage, message, message.getId(), new ArrayList<Message>(), Collections.emptySet(), pipelineInterpreterTracer.getSimulatorInterpreterListener());
        return message;
    }

    public Message createMessage(String messageString) {
        Message message;
        block4: {
            try {
                Map map = (Map)this.objectMapper.readValue(messageString, Map.class);
                if (!map.containsKey("_id")) {
                    map.put("_id", UUID.randomUUID().toString());
                }
                String messageField = "message";
                if (map.containsKey("message") && !(map.get("message") instanceof String)) {
                    map.put("message", String.valueOf(map.get("message")));
                }
                message = this.messageFactory.createMessage(map);
            }
            catch (JacksonException e) {
                message = this.messageFactory.createMessage(messageString, "127.0.0.1", DateTime.now((DateTimeZone)DateTimeZone.UTC));
                if (!StringUtils.startsWith((String)StringUtils.trim((String)messageString), (String)"{")) break block4;
                message.addField("gl2_simulator_json_error", "Cannot parse simulation message as JSON. Using as raw message field instead: " + e.getMessage());
            }
        }
        return message;
    }
}

