/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.threatintel.adapters.tor;

import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.Multimap;
import com.google.inject.assistedinject.Assisted;
import jakarta.inject.Inject;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.graylog.plugins.threatintel.PluginConfigService;
import org.graylog.plugins.threatintel.adapters.tor.;
import org.graylog.plugins.threatintel.adapters.tor.TorExitNodeListParser;
import org.graylog.plugins.threatintel.tools.AdapterDisabledException;
import org.graylog2.plugin.lookup.LookupCachePurge;
import org.graylog2.plugin.lookup.LookupDataAdapter;
import org.graylog2.plugin.lookup.LookupDataAdapterConfiguration;
import org.graylog2.plugin.lookup.LookupResult;
import org.joda.time.Duration;

public class TorExitNodeDataAdapter
extends LookupDataAdapter {
    public static final String NAME = "torexitnode";
    private final OkHttpClient client;
    private final TorExitNodeListParser parser;
    private final PluginConfigService pluginConfigService;
    private Map<String, List<String>> torExitNodes = Collections.emptyMap();

    @Inject
    public TorExitNodeDataAdapter(@Assisted(value="id") String id, @Assisted(value="name") String name, @Assisted LookupDataAdapterConfiguration config, MetricRegistry metricRegistry, TorExitNodeListParser torExitNodeListParser, OkHttpClient httpClient, PluginConfigService pluginConfigService) {
        super(id, name, config, metricRegistry);
        this.client = httpClient.newBuilder().followRedirects(true).followSslRedirects(true).build();
        this.parser = torExitNodeListParser;
        this.pluginConfigService = pluginConfigService;
    }

    @Override
    protected void doStart() throws Exception {
        if (!this.pluginConfigService.config().getCurrent().torEnabled()) {
            throw new AdapterDisabledException("TOR service is disabled, not starting TOR exit addresses adapter. To enable it please go to System / Configurations.");
        }
        Response torExitNodeListResponse = this.client.newCall(new Request.Builder().get().url(new HttpUrl.Builder().scheme("https").host("check.torproject.org").addPathSegment("exit-addresses").build()).build()).execute();
        ResponseBody body = torExitNodeListResponse.body();
        if (torExitNodeListResponse.isSuccessful() && body != null) {
            this.torExitNodes = this.parser.parse(body.string());
        }
    }

    @Override
    protected void doStop() throws Exception {
    }

    @Override
    public Duration refreshInterval() {
        if (!this.pluginConfigService.config().getCurrent().torEnabled()) {
            return Duration.ZERO;
        }
        return Duration.standardMinutes((long)60L);
    }

    @Override
    protected void doRefresh(LookupCachePurge cachePurge) throws Exception {
        this.doStart();
        cachePurge.purgeAll();
    }

    @Override
    protected LookupResult doGet(Object key) {
        List<String> value = this.torExitNodes.get(key.toString());
        if (value != null) {
            StringJoiner stringJoiner = new StringJoiner(", ");
            value.forEach(stringJoiner::add);
            return LookupResult.multi(stringJoiner.toString(), Map.of("node_ids", value));
        }
        return LookupResult.empty();
    }

    @Override
    public void set(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    @JsonAutoDetect
    @JsonDeserialize(builder=.AutoValue_TorExitNodeDataAdapter_Config.Builder.class)
    @JsonTypeName(value="torexitnode")
    @AutoValue
    public static abstract class Config
    implements LookupDataAdapterConfiguration {
        @Override
        @JsonProperty(value="type")
        public abstract String type();

        public static Builder builder() {
            return new .AutoValue_TorExitNodeDataAdapter_Config.Builder();
        }

        @Override
        public Optional<Multimap<String, String>> validate() {
            return Optional.empty();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            @JsonProperty(value="type")
            public abstract Builder type(String var1);

            public abstract Config build();
        }
    }

    public static class Descriptor
    extends LookupDataAdapter.Descriptor<Config> {
        public Descriptor() {
            super(TorExitNodeDataAdapter.NAME, Config.class);
        }

        @Override
        public Config defaultConfiguration() {
            return Config.builder().type(TorExitNodeDataAdapter.NAME).build();
        }
    }

    public static interface Factory
    extends LookupDataAdapter.Factory<TorExitNodeDataAdapter> {
        @Override
        public TorExitNodeDataAdapter create(@Assisted(value="id") String var1, @Assisted(value="name") String var2, LookupDataAdapterConfiguration var3);

        @Override
        public Descriptor getDescriptor();
    }
}

