/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.threatintel.functions.global;

import com.google.common.eventbus.EventBus;
import jakarta.inject.Inject;
import java.util.Map;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.graylog.plugins.threatintel.ThreatIntelPluginConfiguration;
import org.graylog.plugins.threatintel.functions.DomainFunctions;
import org.graylog.plugins.threatintel.functions.GenericLookupResult;
import org.graylog.plugins.threatintel.functions.abusech.AbuseChRansomDomainLookupFunction;
import org.graylog.plugins.threatintel.functions.global.AbstractGlobalLookupFunction;
import org.graylog.plugins.threatintel.functions.global.GlobalLookupResult;
import org.graylog.plugins.threatintel.functions.misc.LookupTableFunction;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalDomainLookupFunction
extends AbstractGlobalLookupFunction {
    private static final Logger LOG = LoggerFactory.getLogger(GlobalDomainLookupFunction.class);
    public static final String NAME = "threat_intel_lookup_domain";
    private static final String VALUE = "domain_name";
    private static final String PREFIX = "prefix";
    private final ParameterDescriptor<String, String> valueParam = ParameterDescriptor.string("domain_name").description("The domain to look up. Example: foo.example.org (A trailing dot ('.') will be ignored.)").build();
    private final ParameterDescriptor<String, String> prefixParam = ParameterDescriptor.string("prefix").description("A prefix for results. For example \"src\" will result in fields called \"src_threat_indicated\".").build();
    private Map<String, LookupTableFunction<? extends GenericLookupResult>> domainFunctions;

    @Inject
    public GlobalDomainLookupFunction(@DomainFunctions Map<String, LookupTableFunction<? extends GenericLookupResult>> domainFunctions, ClusterConfigService clusterConfigService, EventBus serverEventBus) {
        super(clusterConfigService, serverEventBus);
        this.domainFunctions = domainFunctions;
    }

    @Override
    public GlobalLookupResult evaluate(FunctionArgs args, EvaluationContext context) {
        String domain = this.valueParam.required(args, context);
        String prefix = this.prefixParam.required(args, context);
        if (domain == null) {
            LOG.error("NULL value parameter passed to global domain lookup.");
            return null;
        }
        if (prefix == null) {
            LOG.error("NULL prefix parameter passed to global domain lookup.");
            return null;
        }
        LOG.debug("Running global lookup for domain [{}] with prefix [{}].", (Object)domain, (Object)prefix);
        return this.matchEntityAgainstFunctions(this.domainFunctions, args, context, prefix);
    }

    @Override
    boolean isEnabled(LookupTableFunction<? extends GenericLookupResult> function) {
        ThreatIntelPluginConfiguration configuration = this.threatIntelPluginConfiguration();
        if (function.getClass().equals(AbuseChRansomDomainLookupFunction.class)) {
            return configuration.abusechRansomEnabled();
        }
        return true;
    }

    @Override
    public FunctionDescriptor<GlobalLookupResult> descriptor() {
        return FunctionDescriptor.builder().name(NAME).description("Match a domain name against all enabled threat intel sources. (except OTX)").params(this.valueParam, this.prefixParam).returnType(GlobalLookupResult.class).build();
    }
}

