/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.migrations.V20191203120602_MigrateSavedSearchesToViewsSupport.savedsearch;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.graylog.plugins.views.migrations.V20191203120602_MigrateSavedSearchesToViewsSupport.savedsearch.AbsoluteTimeRangeQuery;
import org.graylog.plugins.views.migrations.V20191203120602_MigrateSavedSearchesToViewsSupport.savedsearch.KeywordTimeRangeQuery;
import org.graylog.plugins.views.migrations.V20191203120602_MigrateSavedSearchesToViewsSupport.savedsearch.RelativeTimeRangeQuery;
import org.graylog.plugins.views.migrations.V20191203120602_MigrateSavedSearchesToViewsSupport.view.MessagesWidget;
import org.graylog.plugins.views.migrations.V20191203120602_MigrateSavedSearchesToViewsSupport.view.TimeRange;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="rangeType", visible=true)
@JsonSubTypes(value={@JsonSubTypes.Type(value=AbsoluteTimeRangeQuery.class, name="absolute"), @JsonSubTypes.Type(value=KeywordTimeRangeQuery.class, name="keyword"), @JsonSubTypes.Type(value=RelativeTimeRangeQuery.class, name="relative")})
public abstract class Query {
    private final String TIMESTAMP_FIELD = "timestamp";
    private final List<String> DEFAULT_FIELDS = ImmutableList.of((Object)"timestamp", (Object)"source", (Object)"message");

    @JsonProperty(value="rangeType")
    abstract String rangeType();

    abstract Optional<String> fields();

    public abstract String query();

    public abstract Optional<String> streamId();

    public abstract TimeRange toTimeRange();

    public MessagesWidget toMessagesWidget(String messageListId) {
        List<String> usedFieldsWithoutMessage = this.fieldsList().stream().filter(field -> !field.equals("message")).collect(Collectors.toList());
        boolean showMessageRow = this.fieldsList().contains("message");
        return MessagesWidget.create(messageListId, usedFieldsWithoutMessage, showMessageRow);
    }

    private List<String> addTimestampFieldIfMissing(List<String> fields) {
        if (!fields.contains("timestamp")) {
            ArrayList<String> fieldsWithTimestamp = new ArrayList<String>(fields.size() + 1);
            fieldsWithTimestamp.add("timestamp");
            fieldsWithTimestamp.addAll(fields);
            return fieldsWithTimestamp;
        }
        return fields;
    }

    private List<String> fieldsList() {
        return this.fields().filter(fields -> !fields.trim().isEmpty()).map(fields -> Splitter.on((String)",").splitToList((CharSequence)fields)).map(this::addTimestampFieldIfMissing).orElse(this.DEFAULT_FIELDS);
    }
}

