/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.export;

import au.com.bytecode.opencsv.CSVWriter;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.graylog.plugins.views.search.export.SimpleMessageChunk;
import org.graylog.plugins.views.search.export.SimpleMessageChunkWriter;
import org.graylog2.rest.MoreMediaTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Produces(value={"text/csv"})
public class SimpleMessageChunkCsvWriter
extends SimpleMessageChunkWriter {
    private static final Logger LOG = LoggerFactory.getLogger(MessageBodyWriter.class);

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.typesMatch(type, genericType) && MoreMediaTypes.TEXT_CSV_TYPE.isCompatible(mediaType);
    }

    public void writeTo(SimpleMessageChunk chunk, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        OutputStreamWriter writer = new OutputStreamWriter(entityStream, StandardCharsets.UTF_8);
        try (CSVWriter csvWriter = new CSVWriter((Writer)writer);){
            this.writeHeaderIfFirstChunk(chunk, csvWriter);
            this.writeValues(chunk, csvWriter);
            if (csvWriter.checkError()) {
                LOG.error("Encountered unspecified error when writing message result as CSV, result is likely malformed.");
            }
        }
    }

    private void writeHeaderIfFirstChunk(SimpleMessageChunk chunk, CSVWriter csvWriter) {
        if (chunk.isFirstChunk()) {
            csvWriter.writeNext(chunk.fieldsInOrder().toArray(new String[0]));
        }
    }

    private void writeValues(SimpleMessageChunk chunk, CSVWriter csvWriter) {
        List<String[]> valueMatrix = this.valuesAsStringsInOrder(chunk);
        csvWriter.writeAll(valueMatrix);
    }

    private List<String[]> valuesAsStringsInOrder(SimpleMessageChunk simpleMessageChunk) {
        return Arrays.stream(simpleMessageChunk.getAllValuesInOrder()).map(this::toStringArray).collect(Collectors.toList());
    }

    private String[] toStringArray(Object[] objects) {
        return (String[])Arrays.stream(objects).map(o -> o == null ? null : o.toString()).toArray(String[]::new);
    }
}

