/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.rest;

import jakarta.inject.Inject;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.PreMatching;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.graylog.plugins.views.search.export.ExportFormat;
import org.graylog.plugins.views.search.rest.MessagesResource;
import org.graylog2.rest.MoreMediaTypes;

@PreMatching
public class MessageExportFormatFilter
implements ContainerRequestFilter {
    private static final Pattern PATTERN = Pattern.compile("^/");
    private final Map<MediaType, ExportFormat> supportedFormats;
    private final String targetPath;

    @Inject
    public MessageExportFormatFilter(Set<ExportFormat> supportedFormats) {
        this.supportedFormats = supportedFormats.stream().collect(Collectors.toMap(ExportFormat::mimeType, Function.identity()));
        this.targetPath = "api/" + PATTERN.matcher(MessagesResource.class.getAnnotation(Path.class).value()).replaceFirst("");
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        if (!requestContext.getUriInfo().getPath().endsWith(this.targetPath)) {
            return;
        }
        List acceptedFormats = requestContext.getAcceptableMediaTypes();
        Map<MediaType, ExportFormat> exportFormatCandidates = this.supportedFormats.entrySet().stream().filter((? super T entry) -> acceptedFormats.stream().anyMatch(acceptedFormat -> ((MediaType)entry.getKey()).isCompatible(acceptedFormat))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        if (exportFormatCandidates.isEmpty()) {
            requestContext.abortWith(Response.status((Response.Status)Response.Status.UNSUPPORTED_MEDIA_TYPE).build());
            return;
        }
        Map<MediaType, Optional> candidateErrors = exportFormatCandidates.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((ExportFormat)entry.getValue()).hasError()));
        if (candidateErrors.values().stream().allMatch(Optional::isPresent)) {
            String errorMessage = candidateErrors.values().stream().map(optionalError -> optionalError.orElse("")).collect(Collectors.joining("\n"));
            requestContext.abortWith(Response.status((Response.Status)Response.Status.UNSUPPORTED_MEDIA_TYPE).entity((Object)errorMessage).type(MoreMediaTypes.TEXT_PLAIN_TYPE).build());
            return;
        }
        List allowedMediaTypes = candidateErrors.entrySet().stream().filter((? super T entry) -> !((Optional)entry.getValue()).isPresent()).map(Map.Entry::getKey).map(MediaType::toString).collect(Collectors.toList());
        requestContext.getHeaders().put((Object)"Accept", allowedMediaTypes);
    }
}

