/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.database.dbcatalog;

import com.google.common.base.Stopwatch;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import org.graylog2.database.dbcatalog.DbEntitiesCatalog;
import org.graylog2.database.dbcatalog.impl.ClassGraphDbEntitiesScanningMethod;
import org.graylog2.database.dbcatalog.impl.DbEntitiesScanningMethod;
import org.graylog2.shared.plugins.ChainingClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbEntitiesScanner
implements Provider<DbEntitiesCatalog> {
    private static final Logger LOG = LoggerFactory.getLogger(DbEntitiesScanner.class);
    private final String[] packagesToScan;
    private final String[] packagesToExclude;
    private final ChainingClassLoader chainingClassLoader;
    private final DbEntitiesScanningMethod dbEntitiesScanningMethod = new ClassGraphDbEntitiesScanningMethod();

    @Inject
    public DbEntitiesScanner(ChainingClassLoader chainingClassLoader) {
        this.chainingClassLoader = chainingClassLoader;
        this.packagesToScan = new String[]{"org.graylog2", "org.graylog"};
        this.packagesToExclude = new String[]{"org.graylog.shaded", "org.graylog.storage", "org.graylog2.migrations"};
    }

    DbEntitiesScanner(String[] packagesToScan, String[] packagesToExclude) {
        this.chainingClassLoader = null;
        this.packagesToScan = packagesToScan;
        this.packagesToExclude = packagesToExclude;
    }

    public DbEntitiesCatalog get() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        DbEntitiesCatalog catalog = this.dbEntitiesScanningMethod.scan(this.packagesToScan, this.packagesToExclude, this.chainingClassLoader);
        stopwatch.stop();
        LOG.info("{} entities have been scanned and added to DB Entity Catalog, it took {}", (Object)catalog.size(), (Object)stopwatch);
        return catalog;
    }
}

