/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.database.entities;

import java.util.Objects;
import org.graylog2.database.entities.DefaultEntityScope;
import org.graylog2.database.entities.ScopedEntity;

public abstract class EntityScope {
    public abstract String getName();

    public abstract boolean isMutable();

    public boolean isMutable(ScopedEntity existingEntity, ScopedEntity updatedEntity) {
        return this.isMutable();
    }

    public abstract boolean isDeletable();

    public int hashCode() {
        int hash = 5;
        hash = 79 * hash + Objects.hashCode(this.getName());
        hash = 79 * hash + (this.isMutable() ? 1 : 0);
        return hash;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DefaultEntityScope other = (DefaultEntityScope)object;
        if (this.isMutable() != other.isMutable()) {
            return false;
        }
        if (this.isDeletable() != other.isDeletable()) {
            return false;
        }
        return Objects.equals(this.getName(), other.getName());
    }
}

