/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.decorators;

import com.google.common.collect.ImmutableMap;
import com.google.inject.assistedinject.Assisted;
import io.opentelemetry.instrumentation.annotations.WithSpan;
import jakarta.inject.Inject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.validator.routines.UrlValidator;
import org.graylog2.decorators.Decorator;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.MessageFactory;
import org.graylog2.plugin.configuration.ConfigurationRequest;
import org.graylog2.plugin.configuration.fields.TextField;
import org.graylog2.plugin.decorators.SearchResponseDecorator;
import org.graylog2.rest.models.messages.responses.ResultMessageSummary;
import org.graylog2.rest.resources.search.responses.SearchResponse;

public class LinkFieldDecorator
implements SearchResponseDecorator {
    public static final String CK_LINK_FIELD = "link_field";
    private static final UrlValidator URL_VALIDATOR = new UrlValidator(new String[]{"http", "https"}, 10L);
    private final String linkField;
    private final MessageFactory messageFactory;

    @Inject
    public LinkFieldDecorator(@Assisted Decorator decorator, MessageFactory messageFactory) {
        this.linkField = (String)Objects.requireNonNull(decorator.config().get(CK_LINK_FIELD), "link_field cannot be null");
        this.messageFactory = messageFactory;
    }

    @Override
    @WithSpan
    public SearchResponse apply(SearchResponse searchResponse) {
        List<ResultMessageSummary> summaries = searchResponse.messages().stream().map(summary -> {
            if (!summary.message().containsKey(this.linkField)) {
                return summary;
            }
            Message message = this.messageFactory.createMessage((Map<String, Object>)ImmutableMap.copyOf(summary.message()));
            String href = (String)summary.message().get(this.linkField);
            if (this.isValidUrl(href)) {
                HashMap<String, String> decoratedField = new HashMap<String, String>();
                decoratedField.put("type", "a");
                decoratedField.put("href", href);
                message.addField(this.linkField, decoratedField);
            } else {
                message.addField(this.linkField, href);
            }
            return summary.toBuilder().message(message.getFields()).build();
        }).collect(Collectors.toList());
        return searchResponse.toBuilder().messages(summaries).build();
    }

    private boolean isValidUrl(String url) {
        return URL_VALIDATOR.isValid(url);
    }

    public static class Descriptor
    extends SearchResponseDecorator.Descriptor {
        public Descriptor() {
            super("Hyperlink String", "http://docs.graylog.org/", "Hyperlink string");
        }
    }

    public static class Config
    implements SearchResponseDecorator.Config {
        @Override
        public ConfigurationRequest getRequestedConfiguration() {
            return new ConfigurationRequest(){
                {
                    this.addField(new TextField(LinkFieldDecorator.CK_LINK_FIELD, "Link field", "message", "The field that will be transformed into a hyperlink.", new TextField.Attribute[0]));
                }
            };
        }
    }

    public static interface Factory
    extends SearchResponseDecorator.Factory {
        @Override
        public LinkFieldDecorator create(Decorator var1);

        @Override
        public Config getConfig();

        @Override
        public Descriptor getDescriptor();
    }
}

