/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.indices.jobs;

import com.google.inject.assistedinject.Assisted;
import jakarta.inject.Inject;
import java.util.concurrent.atomic.AtomicLong;
import org.graylog2.indexer.IndexSet;
import org.graylog2.indexer.indexset.IndexSetConfig;
import org.graylog2.indexer.indices.Indices;
import org.graylog2.indexer.ranges.MongoIndexRangeService;
import org.graylog2.system.jobs.SystemJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexSetCleanupJob
extends SystemJob {
    private static final Logger LOG = LoggerFactory.getLogger(IndexSetCleanupJob.class);
    private static final int MAX_CONCURRENCY = 1000;
    private final Indices indices;
    private final MongoIndexRangeService indexRangeService;
    private final IndexSet indexSet;
    private volatile boolean cancel;
    private volatile long total = 0L;
    private final AtomicLong deleted = new AtomicLong(0L);

    @Inject
    public IndexSetCleanupJob(Indices indices, MongoIndexRangeService indexRangeService, @Assisted IndexSet indexSet) {
        this.indices = indices;
        this.indexRangeService = indexRangeService;
        this.indexSet = indexSet;
        this.cancel = false;
    }

    @Override
    public void execute() {
        IndexSetConfig config = this.indexSet.getConfig();
        String[] managedIndices = this.indexSet.getManagedIndices();
        this.total = managedIndices.length;
        try {
            LOG.info("Deleting index template <{}> from Elasticsearch", (Object)config.indexTemplateName());
            this.indices.deleteIndexTemplate(this.indexSet);
        }
        catch (Exception e) {
            LOG.error("Unable to delete index template <{}>", (Object)config.indexTemplateName(), (Object)e);
        }
        for (String indexName : managedIndices) {
            if (this.cancel) {
                LOG.info("Cancel requested. Deleted <{}> of <{}> indices.", (Object)this.deleted, (Object)this.total);
                break;
            }
            try {
                LOG.info("Removing index range information for index: {}", (Object)indexName);
                this.indexRangeService.remove(indexName);
                LOG.info("Deleting index <{}> in index set <{}> ({})", new Object[]{indexName, config.id(), config.title()});
                this.indices.delete(indexName);
                this.deleted.incrementAndGet();
            }
            catch (Exception e) {
                LOG.error("Unable to delete index <{}>", (Object)indexName, (Object)e);
            }
        }
    }

    @Override
    public void requestCancel() {
        this.cancel = true;
    }

    @Override
    public int getProgress() {
        if (this.total <= 0L) {
            return 0;
        }
        return (int)Math.floor(this.deleted.floatValue() / (float)this.total * 100.0f);
    }

    @Override
    public int maxConcurrency() {
        return 1000;
    }

    @Override
    public boolean providesProgress() {
        return true;
    }

    @Override
    public boolean isCancelable() {
        return true;
    }

    @Override
    public String getDescription() {
        return "Deletes all indices in an index set.";
    }

    @Override
    public String getClassName() {
        return this.getClass().getCanonicalName();
    }

    public static interface Factory {
        public IndexSetCleanupJob create(IndexSet var1);
    }
}

