/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.results;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Range;
import java.util.HashMap;
import java.util.Map;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.MessageFactory;
import org.graylog2.plugin.Tools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultMessage {
    private static final Logger LOG = LoggerFactory.getLogger(ResultMessage.class);
    private final MessageFactory messageFactory;
    private Message message;
    private String index;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Multimap<String, Range<Integer>> highlightRanges;

    ResultMessage(MessageFactory messageFactory) {
        this.messageFactory = messageFactory;
    }

    ResultMessage(MessageFactory messageFactory, String id, String index, Map<String, Object> message, Multimap<String, Range<Integer>> highlightRanges) {
        this(messageFactory);
        this.index = index;
        this.highlightRanges = highlightRanges;
        this.setMessage(id, message);
    }

    public void setMessage(Message message) {
        this.message = message;
    }

    public void setMessage(String id, Map<String, Object> message) {
        HashMap tmp = Maps.newHashMap();
        tmp.putAll(message);
        tmp.put("_id", id);
        if (tmp.containsKey("timestamp")) {
            Object tsField = tmp.get("timestamp");
            try {
                tmp.put("timestamp", Tools.ES_DATE_FORMAT_FORMATTER.parseDateTime(String.valueOf(tsField)));
            }
            catch (IllegalArgumentException e) {
                LOG.warn("Could not parse timestamp of message {}", message.get("id"), (Object)e);
            }
        }
        this.message = this.messageFactory.createMessage(tmp);
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public Message getMessage() {
        return this.message;
    }

    public String getIndex() {
        return this.index;
    }
}

