/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.rotation.strategies;

import jakarta.inject.Inject;
import java.text.MessageFormat;
import java.util.Locale;
import javax.annotation.Nullable;
import org.graylog2.indexer.IndexNotFoundException;
import org.graylog2.indexer.IndexSet;
import org.graylog2.indexer.indices.Indices;
import org.graylog2.indexer.rotation.common.IndexRotator;
import org.graylog2.indexer.rotation.strategies.MessageCountRotationStrategyConfig;
import org.graylog2.plugin.indexer.rotation.RotationStrategy;
import org.graylog2.plugin.indexer.rotation.RotationStrategyConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageCountRotationStrategy
implements RotationStrategy {
    public static final String NAME = "count";
    private static final Logger log = LoggerFactory.getLogger(MessageCountRotationStrategy.class);
    private final Indices indices;
    private final IndexRotator indexRotator;

    @Inject
    public MessageCountRotationStrategy(Indices indices, IndexRotator indexRotator) {
        this.indices = indices;
        this.indexRotator = indexRotator;
    }

    @Override
    public void rotate(IndexSet indexSet) {
        this.indexRotator.rotate(indexSet, this::shouldRotate);
    }

    @Override
    public Class<? extends RotationStrategyConfig> configurationClass() {
        return MessageCountRotationStrategyConfig.class;
    }

    @Override
    public RotationStrategyConfig defaultConfiguration() {
        return MessageCountRotationStrategyConfig.createDefault();
    }

    @Nullable
    private IndexRotator.Result shouldRotate(String index, IndexSet indexSet) {
        if (!(indexSet.getConfig().rotationStrategy() instanceof MessageCountRotationStrategyConfig)) {
            throw new IllegalStateException("Invalid rotation strategy config <" + indexSet.getConfig().rotationStrategy().getClass().getCanonicalName() + "> for index set <" + indexSet.getConfig().id() + ">");
        }
        MessageCountRotationStrategyConfig config = (MessageCountRotationStrategyConfig)indexSet.getConfig().rotationStrategy();
        try {
            long numberOfMessages = this.indices.numberOfMessages(index);
            boolean shouldRotate = numberOfMessages > (long)config.maxDocsPerIndex();
            MessageFormat format = shouldRotate ? new MessageFormat("Number of messages in <{0}> ({1}) is higher than the limit ({2}). Pointing deflector to new index now!", Locale.ENGLISH) : new MessageFormat("Number of messages in <{0}> ({1}) is lower than the limit ({2}). Not doing anything.", Locale.ENGLISH);
            String message = format.format(new Object[]{index, numberOfMessages, config.maxDocsPerIndex()});
            return IndexRotator.createResult(shouldRotate, message, this.getClass().getCanonicalName());
        }
        catch (IndexNotFoundException e) {
            log.error("Unknown index, cannot perform rotation", (Throwable)e);
            return null;
        }
    }

    @Override
    public String getStrategyName() {
        return NAME;
    }
}

