/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.cluster;

import com.codahale.metrics.annotation.Timed;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.cluster.Node;
import org.graylog2.cluster.NodeNotFoundException;
import org.graylog2.cluster.NodeService;
import org.graylog2.rest.RemoteInterfaceProvider;
import org.graylog2.rest.resources.system.RemoteSystemProcessingResource;
import org.graylog2.shared.rest.resources.ProxiedResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Response;

@RequiresAuthentication
@Api(value="Cluster/Processing", description="Cluster-wide processing status control.")
@Path(value="/cluster/{nodeId}/processing")
@Produces(value={"application/json"})
public class ClusterSystemProcessingResource
extends ProxiedResource {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterSystemProcessingResource.class);

    @Inject
    public ClusterSystemProcessingResource(NodeService nodeService, RemoteInterfaceProvider remoteInterfaceProvider, @Context HttpHeaders httpHeaders, @Named(value="proxiedRequestsExecutorService") ExecutorService executorService) throws NodeNotFoundException {
        super(httpHeaders, nodeService, remoteInterfaceProvider, executorService);
    }

    private RemoteSystemProcessingResource getRemoteSystemProcessingResource(String nodeId) throws NodeNotFoundException {
        Node targetNode = this.nodeService.byNodeId(nodeId);
        return this.remoteInterfaceProvider.get(targetNode, this.getAuthenticationToken(), RemoteSystemProcessingResource.class);
    }

    @POST
    @Timed
    @ApiOperation(value="Pause message processing on node", notes="If the message journal is enabled, incoming messages will be spooled on disk, if it is disabled, you might lose messages from inputs which cannot buffer themselves, like AMQP or Kafka-based inputs.")
    @Path(value="pause")
    @NoAuditEvent(value="proxy resource, audit event will be emitted on target node")
    public void pause(@ApiParam(name="nodeId", value="The id of the node where processing will be paused.", required=true) @PathParam(value="nodeId") String nodeId) throws IOException, NodeNotFoundException {
        Response response = this.getRemoteSystemProcessingResource(nodeId).pause().execute();
        if (!response.isSuccessful()) {
            LOG.warn("Unable to pause message processing on node {}: {}", (Object)nodeId, (Object)response.message());
            throw new WebApplicationException(response.message(), Response.Status.BAD_GATEWAY);
        }
    }

    @POST
    @Timed
    @ApiOperation(value="Resume message processing on node")
    @Path(value="resume")
    @NoAuditEvent(value="proxy resource, audit event will be emitted on target node")
    public void resume(@ApiParam(name="nodeId", value="The id of the node where processing will be resumed.", required=true) @PathParam(value="nodeId") String nodeId) throws IOException, NodeNotFoundException {
        Response response = this.getRemoteSystemProcessingResource(nodeId).resume().execute();
        if (!response.isSuccessful()) {
            LOG.warn("Unable to resume message processing on node {}: {}", (Object)nodeId, (Object)response.message());
            throw new WebApplicationException(response.message(), Response.Status.BAD_GATEWAY);
        }
    }
}

