/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.streams.rules;

import com.codahale.metrics.annotation.Timed;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.database.NotFoundException;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.plugin.streams.StreamRule;
import org.graylog2.plugin.streams.StreamRuleType;
import org.graylog2.rest.resources.streams.responses.SingleStreamRuleSummaryResponse;
import org.graylog2.rest.resources.streams.responses.StreamRuleListResponse;
import org.graylog2.rest.resources.streams.responses.StreamRuleTypeResponse;
import org.graylog2.rest.resources.streams.rules.requests.CreateStreamRuleRequest;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.streams.StreamRuleService;
import org.graylog2.streams.StreamService;

@RequiresAuthentication
@Api(value="StreamRules", description="Manage stream rules", tags={"cloud"})
@Path(value="/streams/{streamid}/rules")
public class StreamRuleResource
extends RestResource {
    private final StreamRuleService streamRuleService;
    private final StreamService streamService;

    @Inject
    public StreamRuleResource(StreamRuleService streamRuleService, StreamService streamService) {
        this.streamRuleService = streamRuleService;
        this.streamService = streamService;
    }

    @POST
    @Timed
    @ApiOperation(value="Create a stream rule")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @AuditEvent(type="server:stream_rule:create")
    public Response create(@ApiParam(name="streamid", value="The stream id this new rule belongs to.", required=true) @PathParam(value="streamid") String streamId, @ApiParam(name="JSON body", required=true) @Valid @NotNull CreateStreamRuleRequest cr) throws NotFoundException, ValidationException {
        this.checkPermission("streams:edit", streamId);
        this.checkNotEditable(streamId, "Cannot add stream rules to non-editable streams.");
        this.streamService.load(streamId);
        StreamRule streamRule = this.streamRuleService.create(streamId, cr);
        String id = this.streamRuleService.save(streamRule);
        SingleStreamRuleSummaryResponse response = SingleStreamRuleSummaryResponse.create(id);
        URI streamRuleUri = this.getUriBuilderToSelf().path(StreamRuleResource.class).path("{streamRuleId}").build(new Object[]{streamId, id});
        return Response.created((URI)streamRuleUri).entity((Object)response).build();
    }

    @PUT
    @Path(value="/{streamRuleId}")
    @Timed
    @ApiOperation(value="Update a stream rule")
    @ApiResponses(value={@ApiResponse(code=404, message="Stream or stream rule not found."), @ApiResponse(code=400, message="Invalid JSON Body.")})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @AuditEvent(type="server:stream_rule:update")
    public SingleStreamRuleSummaryResponse update(@ApiParam(name="streamid", value="The stream id this rule belongs to.", required=true) @PathParam(value="streamid") String streamid, @ApiParam(name="streamRuleId", value="The stream rule id we are updating", required=true) @PathParam(value="streamRuleId") String streamRuleId, @ApiParam(name="JSON body", required=true) @Valid @NotNull CreateStreamRuleRequest cr) throws NotFoundException, ValidationException {
        this.checkPermission("streams:edit", streamid);
        this.checkNotEditable(streamid, "Cannot update stream rules on non-editable streams.");
        StreamRule streamRule = this.streamRuleService.load(streamRuleId);
        if (!streamRule.getStreamId().equals(streamid)) {
            throw new NotFoundException("Couldn't update stream rule " + streamRuleId + "in stream " + streamid);
        }
        StreamRuleType streamRuleType = StreamRuleType.fromInteger(cr.type());
        if (null == streamRuleType) {
            throw new BadRequestException("Unknown stream rule type " + cr.type());
        }
        streamRule.setField(cr.field());
        streamRule.setType(streamRuleType);
        streamRule.setInverted(cr.inverted());
        streamRule.setValue(cr.value());
        streamRule.setDescription(cr.description());
        this.streamRuleService.save(streamRule);
        return SingleStreamRuleSummaryResponse.create(streamRule.getId());
    }

    @POST
    @Path(value="/{streamRuleId}")
    @Timed
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @AuditEvent(type="server:stream_rule:update")
    @Deprecated
    public SingleStreamRuleSummaryResponse updateDeprecated(@PathParam(value="streamid") String streamid, @PathParam(value="streamRuleId") String streamRuleId, @Valid @NotNull CreateStreamRuleRequest cr) throws NotFoundException, ValidationException {
        this.checkNotEditable(streamid, "Cannot remove stream rule on non-editable streams.");
        return this.update(streamid, streamRuleId, cr);
    }

    @GET
    @Timed
    @ApiOperation(value="Get a list of all stream rules")
    @Produces(value={"application/json"})
    public StreamRuleListResponse get(@ApiParam(name="streamid", value="The id of the stream whose stream rules we want.", required=true) @PathParam(value="streamid") String streamid) throws NotFoundException {
        this.checkPermission("streams:read", streamid);
        Stream stream = this.streamService.load(streamid);
        List<StreamRule> streamRules = this.streamRuleService.loadForStream(stream);
        return StreamRuleListResponse.create(streamRules.size(), streamRules);
    }

    @GET
    @Path(value="/{streamRuleId}")
    @Timed
    @ApiOperation(value="Get a single stream rules")
    @Produces(value={"application/json"})
    public StreamRule get(@ApiParam(name="streamid", value="The id of the stream whose stream rule we want.", required=true) @PathParam(value="streamid") String streamid, @ApiParam(name="streamRuleId", value="The stream rule id we are getting", required=true) @PathParam(value="streamRuleId") String streamRuleId) throws NotFoundException {
        this.checkPermission("streams:read", streamid);
        return this.streamRuleService.load(streamRuleId);
    }

    @DELETE
    @Path(value="/{streamRuleId}")
    @Timed
    @ApiOperation(value="Delete a stream rule")
    @ApiResponses(value={@ApiResponse(code=404, message="Stream rule not found."), @ApiResponse(code=400, message="Invalid ObjectId.")})
    @AuditEvent(type="server:stream_rule:delete")
    public void delete(@ApiParam(name="streamid", value="The stream id this new rule belongs to.", required=true) @PathParam(value="streamid") String streamid, @ApiParam(name="streamRuleId", required=true) @PathParam(value="streamRuleId") @NotEmpty String streamRuleId) throws NotFoundException {
        this.checkPermission("streams:edit", streamid);
        this.checkNotEditable(streamid, "Cannot delete stream rule on non-editable streams.");
        StreamRule streamRule = this.streamRuleService.load(streamRuleId);
        if (!streamRule.getStreamId().equals(streamid)) {
            throw new NotFoundException("Couldn't delete stream rule " + streamRuleId + "in stream " + streamid);
        }
        this.streamRuleService.destroy(streamRule);
    }

    @GET
    @Path(value="/types")
    @Timed
    @ApiOperation(value="Get all available stream types")
    @Produces(value={"application/json"})
    public List<StreamRuleTypeResponse> types(@ApiParam(name="streamid", value="The stream id this new rule belongs to.", required=true) @PathParam(value="streamid") String streamid) {
        ArrayList<StreamRuleTypeResponse> result = new ArrayList<StreamRuleTypeResponse>(StreamRuleType.values().length);
        for (StreamRuleType type : StreamRuleType.values()) {
            result.add(StreamRuleTypeResponse.create(type.getValue(), type.name(), type.getShortDesc(), type.getLongDesc()));
        }
        return result;
    }

    private void checkNotEditable(String streamId, String message) {
        if ("000000000000000000000001".equals(streamId) || !Stream.streamIsEditable(streamId)) {
            throw new BadRequestException(message);
        }
    }
}

