/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system.indexer;

import com.codahale.metrics.annotation.Timed;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.indexer.indexset.profile.IndexFieldTypeProfile;
import org.graylog2.indexer.indexset.profile.IndexFieldTypeProfileData;
import org.graylog2.indexer.indexset.profile.IndexFieldTypeProfileIdAndName;
import org.graylog2.indexer.indexset.profile.IndexFieldTypeProfileService;
import org.graylog2.indexer.indexset.profile.IndexFieldTypeProfileWithUsages;
import org.graylog2.rest.models.tools.responses.PageListResponse;
import org.graylog2.shared.rest.resources.RestResource;

@RequiresAuthentication
@Api(value="System/IndexSets/FieldTypeProfiles", tags={"cloud"})
@Path(value="/system/indices/index_sets/profiles")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class IndexFieldTypeProfileResource
extends RestResource {
    private final IndexFieldTypeProfileService profileService;

    @Inject
    public IndexFieldTypeProfileResource(IndexFieldTypeProfileService profileService) {
        this.profileService = profileService;
    }

    @GET
    @Path(value="/{profile_id}")
    @Timed
    @NoAuditEvent(value="No change to the DB")
    @ApiOperation(value="Gets profile by id")
    public IndexFieldTypeProfileWithUsages retrieveById(@ApiParam(name="profile_id") @PathParam(value="profile_id") String profileId) {
        this.checkPermission("mappingprofiles:read", profileId);
        return this.profileService.getWithUsages(profileId).orElseThrow(() -> new NotFoundException("No profile with id : " + profileId));
    }

    @GET
    @Path(value="/paginated")
    @Timed
    @NoAuditEvent(value="No change to the DB")
    @ApiOperation(value="Gets profile by id")
    public PageListResponse<IndexFieldTypeProfileWithUsages> getPage(@ApiParam(name="page") @QueryParam(value="page") @DefaultValue(value="1") int page, @ApiParam(name="per_page") @QueryParam(value="per_page") @DefaultValue(value="50") int perPage, @ApiParam(name="query") @QueryParam(value="query") @DefaultValue(value="") String query, @ApiParam(name="filters") @QueryParam(value="filters") List<String> filters, @ApiParam(name="sort", value="The field to sort the result on", required=true, allowableValues="name") @DefaultValue(value="name") @QueryParam(value="sort") String sort, @ApiParam(name="order", value="The sort direction", allowableValues="asc, desc") @DefaultValue(value="asc") @QueryParam(value="order") String order) {
        this.checkPermission("mappingprofiles:read");
        return this.profileService.getPaginated(query, filters, page, perPage, sort, order);
    }

    @GET
    @Path(value="/all")
    @Timed
    @NoAuditEvent(value="No change to the DB")
    @ApiOperation(value="Gets list of all profiles (their ids and names only)")
    public List<IndexFieldTypeProfileIdAndName> getAll() {
        this.checkPermission("mappingprofiles:read");
        return this.profileService.getAll();
    }

    @POST
    @Timed
    @AuditEvent(type="server:index_field_type_profile:create")
    @ApiOperation(value="Creates a new profile")
    public IndexFieldTypeProfile create(@ApiParam(name="profileData") IndexFieldTypeProfileData profileData) {
        this.checkPermission("mappingprofiles:create");
        return this.profileService.save(new IndexFieldTypeProfile(profileData));
    }

    @PUT
    @Timed
    @AuditEvent(type="server:index_field_type_profile:update")
    @ApiOperation(value="Updates existing profile")
    public void update(@ApiParam(name="profile") IndexFieldTypeProfile profile) {
        this.checkPermission("mappingprofiles:edit", profile.id());
        boolean updated = this.profileService.update(profile.id(), profile);
        if (!updated) {
            throw new NotFoundException("Profile does not exist : " + profile.id());
        }
    }

    @DELETE
    @Path(value="/{profile_id}")
    @Timed
    @AuditEvent(type="server:index_field_type_profile:delete")
    @ApiOperation(value="Removes a profile")
    public void delete(@ApiParam(name="profile_id") @PathParam(value="profile_id") String profileId) {
        this.checkPermission("mappingprofiles:delete", profileId);
        this.profileService.delete(profileId);
    }
}

