/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system.lookup;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.mongodb.DuplicateKeyException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.validation.Validator;
import jakarta.validation.constraints.NotEmpty;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog2.Configuration;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.database.PaginatedList;
import org.graylog2.lookup.CachePurge;
import org.graylog2.lookup.LookupDefaultMultiValue;
import org.graylog2.lookup.LookupDefaultSingleValue;
import org.graylog2.lookup.LookupTable;
import org.graylog2.lookup.LookupTableService;
import org.graylog2.lookup.adapters.LookupDataAdapterValidationContext;
import org.graylog2.lookup.db.DBCacheService;
import org.graylog2.lookup.db.DBDataAdapterService;
import org.graylog2.lookup.db.DBLookupTableService;
import org.graylog2.lookup.dto.CacheDto;
import org.graylog2.lookup.dto.DataAdapterDto;
import org.graylog2.lookup.dto.LookupTableDto;
import org.graylog2.plugin.lookup.LookupCache;
import org.graylog2.plugin.lookup.LookupDataAdapter;
import org.graylog2.plugin.lookup.LookupResult;
import org.graylog2.plugin.rest.ValidationResult;
import org.graylog2.rest.models.system.lookup.CacheApi;
import org.graylog2.rest.models.system.lookup.DataAdapterApi;
import org.graylog2.rest.models.system.lookup.ErrorStates;
import org.graylog2.rest.models.system.lookup.ErrorStatesRequest;
import org.graylog2.rest.models.system.lookup.LookupTableApi;
import org.graylog2.search.SearchQuery;
import org.graylog2.search.SearchQueryField;
import org.graylog2.search.SearchQueryParser;
import org.graylog2.shared.rest.resources.RestResource;
import org.mongojack.DBQuery;
import org.mongojack.DBSort;

@RequiresAuthentication
@Path(value="/system/lookup")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Api(value="System/Lookup", description="Lookup tables", tags={"cloud"})
public class LookupTableResource
extends RestResource {
    private static final ImmutableSet<String> LUT_ALLOWABLE_SORT_FIELDS = ImmutableSet.of((Object)"id", (Object)"title", (Object)"description", (Object)"name");
    private static final ImmutableSet<String> ADAPTER_ALLOWABLE_SORT_FIELDS = ImmutableSet.of((Object)"id", (Object)"title", (Object)"description", (Object)"name");
    private static final ImmutableSet<String> CACHE_ALLOWABLE_SORT_FIELDS = ImmutableSet.of((Object)"id", (Object)"title", (Object)"description", (Object)"name");
    private static final ImmutableMap<String, SearchQueryField> LUT_SEARCH_FIELD_MAPPING = ImmutableMap.builder().put((Object)"id", (Object)SearchQueryField.create("_id", SearchQueryField.Type.OBJECT_ID)).put((Object)"title", (Object)SearchQueryField.create("title")).put((Object)"description", (Object)SearchQueryField.create("description")).put((Object)"name", (Object)SearchQueryField.create("name")).build();
    private static final ImmutableMap<String, SearchQueryField> ADAPTER_SEARCH_FIELD_MAPPING = ImmutableMap.builder().put((Object)"id", (Object)SearchQueryField.create("_id", SearchQueryField.Type.OBJECT_ID)).put((Object)"title", (Object)SearchQueryField.create("title")).put((Object)"description", (Object)SearchQueryField.create("description")).put((Object)"name", (Object)SearchQueryField.create("name")).build();
    private static final ImmutableMap<String, SearchQueryField> CACHE_SEARCH_FIELD_MAPPING = ImmutableMap.builder().put((Object)"id", (Object)SearchQueryField.create("_id", SearchQueryField.Type.OBJECT_ID)).put((Object)"title", (Object)SearchQueryField.create("title")).put((Object)"description", (Object)SearchQueryField.create("description")).put((Object)"name", (Object)SearchQueryField.create("name")).build();
    private final DBLookupTableService dbTableService;
    private final DBDataAdapterService dbDataAdapterService;
    private final DBCacheService dbCacheService;
    private final Map<String, LookupCache.Factory> cacheTypes;
    private final Map<String, LookupDataAdapter.Factory> dataAdapterTypes;
    private final Map<String, LookupDataAdapter.Factory2> dataAdapterTypes2;
    private final SearchQueryParser lutSearchQueryParser;
    private final SearchQueryParser adapterSearchQueryParser;
    private final SearchQueryParser cacheSearchQueryParser;
    private final LookupTableService lookupTableService;
    private final LookupDataAdapterValidationContext lookupDataAdapterValidationContext;
    private final Validator validator;
    private final Configuration configuration;

    @Inject
    public LookupTableResource(DBLookupTableService dbTableService, DBDataAdapterService dbDataAdapterService, DBCacheService dbCacheService, Map<String, LookupCache.Factory> cacheTypes, Map<String, LookupDataAdapter.Factory> dataAdapterTypes, Map<String, LookupDataAdapter.Factory2> dataAdapterTypes2, LookupTableService lookupTableService, LookupDataAdapterValidationContext lookupDataAdapterValidationContext, Validator validator, Configuration configuration) {
        this.dbTableService = dbTableService;
        this.dbDataAdapterService = dbDataAdapterService;
        this.dbCacheService = dbCacheService;
        this.cacheTypes = cacheTypes;
        this.dataAdapterTypes = dataAdapterTypes;
        this.dataAdapterTypes2 = dataAdapterTypes2;
        this.lookupTableService = lookupTableService;
        this.lookupDataAdapterValidationContext = lookupDataAdapterValidationContext;
        this.validator = validator;
        this.configuration = configuration;
        this.lutSearchQueryParser = new SearchQueryParser("title", (Map<String, SearchQueryField>)LUT_SEARCH_FIELD_MAPPING);
        this.adapterSearchQueryParser = new SearchQueryParser("title", (Map<String, SearchQueryField>)ADAPTER_SEARCH_FIELD_MAPPING);
        this.cacheSearchQueryParser = new SearchQueryParser("title", (Map<String, SearchQueryField>)CACHE_SEARCH_FIELD_MAPPING);
    }

    private void checkLookupTableId(String idOrName, LookupTableApi toUpdate) {
        Objects.requireNonNull(idOrName, "idOrName parameter cannot be null");
        if (idOrName.equals(toUpdate.id()) || idOrName.equals(toUpdate.name())) {
            return;
        }
        throw new BadRequestException("URL parameter <" + idOrName + "> does not match parameter in request body");
    }

    private void checkLookupCacheId(String idOrName, CacheApi toUpdate) {
        Objects.requireNonNull(idOrName, "idOrName parameter cannot be null");
        if (idOrName.equals(toUpdate.id()) || idOrName.equals(toUpdate.name())) {
            return;
        }
        throw new BadRequestException("URL parameter <" + idOrName + "> does not match parameter in request body");
    }

    private void checkLookupAdapterId(String idOrName, DataAdapterApi toUpdate) {
        Objects.requireNonNull(idOrName, "idOrName parameter cannot be null");
        if (idOrName.equals(toUpdate.id()) || idOrName.equals(toUpdate.name())) {
            return;
        }
        throw new BadRequestException("URL parameter <" + idOrName + "> does not match parameter in request body");
    }

    @GET
    @Path(value="tables/{name}/query")
    @ApiOperation(value="Query a lookup table")
    @RequiresPermissions(value={"lookuptables:read"})
    public LookupResult performLookup(@ApiParam(name="name") @PathParam(value="name") @NotEmpty String name, @ApiParam(name="key") @QueryParam(value="key") @NotEmpty String key) {
        return this.lookupTableService.newBuilder().lookupTable(name).build().lookup(key);
    }

    @POST
    @Path(value="tables/{idOrName}/purge")
    @ApiOperation(value="Purge lookup table cache")
    @NoAuditEvent(value="Cache purge only")
    @RequiresPermissions(value={"lookuptables:read"})
    public void performPurge(@ApiParam(name="idOrName") @PathParam(value="idOrName") @NotEmpty String idOrName, @ApiParam(name="key") @QueryParam(value="key") String key) {
        Optional<LookupTableDto> lookupTableDto = this.dbTableService.get(idOrName);
        if (!lookupTableDto.isPresent()) {
            throw new NotFoundException("Lookup table <" + idOrName + "> not found");
        }
        Optional<CachePurge> cachePurge = this.lookupTableService.newCachePurge(lookupTableDto.get().name());
        if (cachePurge.isPresent()) {
            if (Strings.isNullOrEmpty((String)key)) {
                cachePurge.get().purgeAll();
            } else {
                cachePurge.get().purgeKey(key);
            }
        } else {
            throw new NotFoundException("Lookup table <" + idOrName + "> not found");
        }
    }

    @GET
    @Path(value="tables")
    @ApiOperation(value="List configured lookup tables")
    @RequiresPermissions(value={"lookuptables:read"})
    public LookupTablePage tables(@ApiParam(name="page") @QueryParam(value="page") @DefaultValue(value="1") int page, @ApiParam(name="per_page") @QueryParam(value="per_page") @DefaultValue(value="50") int perPage, @ApiParam(name="sort", value="The field to sort the result on", required=true, allowableValues="title,description,name,id") @DefaultValue(value="title") @QueryParam(value="sort") String sort, @ApiParam(name="order", value="The sort direction", allowableValues="asc, desc") @DefaultValue(value="desc") @QueryParam(value="order") String order, @ApiParam(name="query") @QueryParam(value="query") String query, @ApiParam(name="resolve") @QueryParam(value="resolve") @DefaultValue(value="false") boolean resolveObjects) {
        if (!LUT_ALLOWABLE_SORT_FIELDS.contains((Object)sort.toLowerCase(Locale.ENGLISH))) {
            sort = "title";
        }
        DBSort.SortBuilder sortBuilder = "desc".equalsIgnoreCase(order) ? DBSort.desc((String)sort) : DBSort.asc((String)sort);
        try {
            SearchQuery searchQuery = this.lutSearchQueryParser.parse(query);
            DBQuery.Query dbQuery = searchQuery.toDBQuery();
            PaginatedList<LookupTableDto> paginated = this.dbTableService.findPaginated(dbQuery, sortBuilder, page, perPage);
            ImmutableSet.Builder caches = ImmutableSet.builder();
            ImmutableSet.Builder dataAdapters = ImmutableSet.builder();
            if (resolveObjects) {
                ImmutableSet.Builder cacheIds = ImmutableSet.builder();
                ImmutableSet.Builder dataAdapterIds = ImmutableSet.builder();
                paginated.forEach(dto -> {
                    cacheIds.add((Object)dto.cacheId());
                    dataAdapterIds.add((Object)dto.dataAdapterId());
                });
                this.dbCacheService.findByIds((Set<String>)cacheIds.build()).forEach(cacheDto -> caches.add((Object)CacheApi.fromDto(cacheDto)));
                this.dbDataAdapterService.findByIds((Set<String>)dataAdapterIds.build()).forEach(dataAdapterDto -> dataAdapters.add((Object)DataAdapterApi.fromDto(dataAdapterDto)));
            }
            return new LookupTablePage(query, paginated.pagination(), paginated.stream().map(LookupTableApi::fromDto).collect(Collectors.toList()), (Collection<CacheApi>)caches.build(), (Collection<DataAdapterApi>)dataAdapters.build());
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(e.getMessage(), (Throwable)e);
        }
    }

    @GET
    @Path(value="tables/{idOrName}")
    @ApiOperation(value="Retrieve the named lookup table")
    public LookupTablePage get(@ApiParam(name="idOrName") @PathParam(value="idOrName") @NotEmpty String idOrName, @ApiParam(name="resolve") @QueryParam(value="resolve") @DefaultValue(value="false") boolean resolveObjects) {
        Optional<LookupTableDto> lookupTableDto = this.dbTableService.get(idOrName);
        if (!lookupTableDto.isPresent()) {
            throw new NotFoundException();
        }
        LookupTableDto tableDto = lookupTableDto.get();
        this.checkPermission("lookuptables:read", tableDto.id());
        Set<CacheApi> caches = Collections.emptySet();
        Set<DataAdapterApi> adapters = Collections.emptySet();
        if (resolveObjects) {
            caches = this.dbCacheService.findByIds(Collections.singleton(tableDto.cacheId())).stream().map(CacheApi::fromDto).collect(Collectors.toSet());
            adapters = this.dbDataAdapterService.findByIds(Collections.singleton(tableDto.dataAdapterId())).stream().map(DataAdapterApi::fromDto).collect(Collectors.toSet());
        }
        PaginatedList<LookupTableApi> result = PaginatedList.singleton(LookupTableApi.fromDto(tableDto), 1, 1);
        return new LookupTablePage(null, result.pagination(), (List<LookupTableApi>)((Object)result), (Collection<CacheApi>)caches, (Collection<DataAdapterApi>)adapters);
    }

    @POST
    @Path(value="tables")
    @AuditEvent(type="server:lut_table:create")
    @ApiOperation(value="Create a new lookup table")
    @RequiresPermissions(value={"lookuptables:create"})
    public LookupTableApi createTable(@ApiParam LookupTableApi lookupTable) {
        try {
            LookupTableDto saved = this.dbTableService.saveAndPostEvent(lookupTable.toDto());
            return LookupTableApi.fromDto(saved);
        }
        catch (DuplicateKeyException e) {
            throw new BadRequestException(e.getMessage());
        }
    }

    @PUT
    @Path(value="tables/{idOrName}")
    @AuditEvent(type="server:lut_table:update")
    @ApiOperation(value="Update the given lookup table")
    public LookupTableApi updateTable(@ApiParam(name="idOrName") @PathParam(value="idOrName") @NotEmpty String idOrName, @Valid @ApiParam LookupTableApi toUpdate) {
        this.checkLookupTableId(idOrName, toUpdate);
        this.checkPermission("lookuptables:edit", toUpdate.id());
        LookupTableDto saved = this.dbTableService.saveAndPostEvent(toUpdate.toDto());
        return LookupTableApi.fromDto(saved);
    }

    @DELETE
    @Path(value="tables/{idOrName}")
    @AuditEvent(type="server:lut_table:delete")
    @ApiOperation(value="Delete the lookup table")
    public LookupTableApi removeTable(@ApiParam(name="idOrName") @PathParam(value="idOrName") @NotEmpty String idOrName) {
        Optional<LookupTableDto> lookupTableDto = this.dbTableService.get(idOrName);
        if (!lookupTableDto.isPresent()) {
            throw new NotFoundException();
        }
        this.checkPermission("lookuptables:delete", lookupTableDto.get().id());
        this.dbTableService.deleteAndPostEvent(idOrName);
        return LookupTableApi.fromDto(lookupTableDto.get());
    }

    @POST
    @Path(value="tables/validate")
    @NoAuditEvent(value="Validation only")
    @ApiOperation(value="Validate the lookup table config")
    @RequiresPermissions(value={"lookuptables:read"})
    public ValidationResult validateTable(@ApiParam LookupTableApi toValidate) {
        LookupTableDto tableDto;
        ValidationResult validation = new ValidationResult();
        this.validator.validate((Object)toValidate, new Class[0]).stream().forEach(v -> validation.addError(v.getPropertyPath().toString(), v.getMessage()));
        Optional<LookupTableDto> dtoOptional = this.dbTableService.get(toValidate.name());
        if (dtoOptional.isPresent() && !(tableDto = dtoOptional.get()).id().equals(toValidate.id())) {
            validation.addError("name", "The lookup table name is already in use.");
        }
        try {
            LookupDefaultSingleValue.create(toValidate.defaultSingleValue(), toValidate.defaultSingleValueType());
        }
        catch (Exception e) {
            validation.addError("default_single_value", e.getMessage());
        }
        try {
            LookupDefaultMultiValue.create(toValidate.defaultMultiValue(), toValidate.defaultMultiValueType());
        }
        catch (Exception e) {
            validation.addError("default_multi_value", e.getMessage());
        }
        return validation;
    }

    @GET
    @Path(value="adapters")
    @ApiOperation(value="List available data adapters")
    @RequiresPermissions(value={"lookuptables:read"})
    public DataAdapterPage adapters(@ApiParam(name="page") @QueryParam(value="page") @DefaultValue(value="1") int page, @ApiParam(name="per_page") @QueryParam(value="per_page") @DefaultValue(value="50") int perPage, @ApiParam(name="sort", value="The field to sort the result on", required=true, allowableValues="title,description,name,id") @DefaultValue(value="title") @QueryParam(value="sort") String sort, @ApiParam(name="order", value="The sort direction", allowableValues="asc, desc") @DefaultValue(value="desc") @QueryParam(value="order") String order, @ApiParam(name="query") @QueryParam(value="query") String query) {
        if (!ADAPTER_ALLOWABLE_SORT_FIELDS.contains((Object)sort.toLowerCase(Locale.ENGLISH))) {
            sort = "title";
        }
        DBSort.SortBuilder sortBuilder = "desc".equalsIgnoreCase(order) ? DBSort.desc((String)sort) : DBSort.asc((String)sort);
        try {
            SearchQuery searchQuery = this.adapterSearchQueryParser.parse(query);
            DBQuery.Query dbQuery = searchQuery.toDBQuery();
            PaginatedList<DataAdapterDto> paginated = this.dbDataAdapterService.findPaginated(dbQuery, sortBuilder, page, perPage);
            return new DataAdapterPage(query, paginated.pagination(), paginated.stream().map(DataAdapterApi::fromDto).collect(Collectors.toList()));
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(e.getMessage(), (Throwable)e);
        }
    }

    @GET
    @Path(value="types/adapters")
    @ApiOperation(value="List available data adapter types")
    @RequiresPermissions(value={"lookuptables:read"})
    public Map<String, LookupDataAdapter.Descriptor> availableAdapterTypes() {
        Stream<LookupDataAdapter.Descriptor> stream1 = this.dataAdapterTypes.values().stream().map(LookupDataAdapter.Factory::getDescriptor);
        Stream<LookupDataAdapter.Descriptor> stream2 = this.dataAdapterTypes2.values().stream().map(LookupDataAdapter.Factory2::getDescriptor);
        Stream<LookupDataAdapter.Descriptor> descriptorStream = Stream.concat(stream1, stream2);
        if (this.configuration.isCloud()) {
            descriptorStream = descriptorStream.filter(descriptor -> descriptor.defaultConfiguration().isCloudCompatible());
        }
        return descriptorStream.collect(Collectors.toMap(LookupDataAdapter.Descriptor::getType, Function.identity()));
    }

    @POST
    @NoAuditEvent(value="Bulk read call")
    @Path(value="errorstates")
    @ApiOperation(value="Retrieve the runtime error states of the given lookup tables, caches and adapters")
    @RequiresPermissions(value={"lookuptables:read"})
    public ErrorStates errorStates(@ApiParam(name="request") @Valid ErrorStatesRequest request) {
        ErrorStates.Builder errorStates = ErrorStates.builder();
        if (request.tables() != null) {
            for (String tableName : request.tables()) {
                LookupTable table = this.lookupTableService.newBuilder().lookupTable(tableName).build().getTable();
                if (table == null) continue;
                errorStates.tables().put(tableName, table.error());
            }
        }
        if (request.dataAdapters() != null) {
            this.lookupTableService.getDataAdapters(request.dataAdapters()).forEach(adapter -> errorStates.dataAdapters().put(adapter.name(), adapter.getError().map(Throwable::getMessage).orElse(null)));
        }
        if (request.caches() != null) {
            this.lookupTableService.getCaches(request.caches()).forEach(cache -> errorStates.caches().put(cache.name(), cache.getError().map(Throwable::getMessage).orElse(null)));
        }
        return errorStates.build();
    }

    @GET
    @Path(value="adapters/{idOrName}")
    @ApiOperation(value="List the given data adapter")
    public DataAdapterApi getAdapter(@ApiParam(name="idOrName") @PathParam(value="idOrName") @NotEmpty String idOrName) {
        Optional<DataAdapterDto> dataAdapterDto = this.dbDataAdapterService.get(idOrName);
        if (dataAdapterDto.isPresent()) {
            this.checkPermission("lookuptables:read", dataAdapterDto.get().id());
            return DataAdapterApi.fromDto(dataAdapterDto.get());
        }
        throw new NotFoundException();
    }

    @GET
    @Path(value="adapters/{name}/query")
    @ApiOperation(value="Query a lookup table")
    @ApiResponses(value={@ApiResponse(code=404, message="If the adapter cannot be found (if it failed or doesn't exist at all)")})
    @RequiresPermissions(value={"lookuptables:read"})
    public LookupResult performAdapterLookup(@ApiParam(name="name") @PathParam(value="name") @NotEmpty String name, @ApiParam(name="key") @QueryParam(value="key") @NotEmpty String key) {
        Collection<LookupDataAdapter> dataAdapters = this.lookupTableService.getDataAdapters(Collections.singleton(name));
        if (!dataAdapters.isEmpty()) {
            return ((LookupDataAdapter)((Object)Iterables.getOnlyElement(dataAdapters))).get(key);
        }
        throw new NotFoundException("Unable to find data adapter " + name);
    }

    @POST
    @Path(value="adapters")
    @AuditEvent(type="server:lut_adapter:create")
    @ApiOperation(value="Create a new data adapter")
    @RequiresPermissions(value={"lookuptables:create"})
    public DataAdapterApi createAdapter(@Valid @ApiParam DataAdapterApi newAdapter) {
        try {
            DataAdapterDto dto = newAdapter.toDto();
            if (this.configuration.isCloud() && !dto.config().isCloudCompatible()) {
                throw new BadRequestException(String.format(Locale.ENGLISH, "The data adapter <%s> is not allowed in the cloud environment!", dto.config().type()));
            }
            DataAdapterDto saved = this.dbDataAdapterService.saveAndPostEvent(dto);
            return DataAdapterApi.fromDto(saved);
        }
        catch (DuplicateKeyException e) {
            throw new BadRequestException(e.getMessage());
        }
    }

    @DELETE
    @Path(value="adapters/{idOrName}")
    @AuditEvent(type="server:lut_adapter:delete")
    @ApiOperation(value="Delete the given data adapter", notes="The data adapter cannot be in use by any lookup table, otherwise the request will fail.")
    public DataAdapterApi deleteAdapter(@ApiParam(name="idOrName") @PathParam(value="idOrName") @NotEmpty String idOrName) {
        Optional<DataAdapterDto> dataAdapterDto = this.dbDataAdapterService.get(idOrName);
        if (!dataAdapterDto.isPresent()) {
            throw new NotFoundException();
        }
        DataAdapterDto dto = dataAdapterDto.get();
        this.checkPermission("lookuptables:delete", dto.id());
        boolean unused = this.dbTableService.findByDataAdapterIds(Collections.singleton(dto.id())).isEmpty();
        if (!unused) {
            throw new BadRequestException("The adapter is still in use, cannot delete.");
        }
        this.dbDataAdapterService.deleteAndPostEvent(idOrName);
        return DataAdapterApi.fromDto(dto);
    }

    @PUT
    @Path(value="adapters/{idOrName}")
    @AuditEvent(type="server:lut_adapter:update")
    @ApiOperation(value="Update the given data adapter settings")
    public DataAdapterApi updateAdapter(@ApiParam(name="idOrName") @PathParam(value="idOrName") @NotEmpty String idOrName, @Valid @ApiParam DataAdapterApi toUpdate) {
        this.checkLookupAdapterId(idOrName, toUpdate);
        this.checkPermission("lookuptables:edit", toUpdate.id());
        DataAdapterDto saved = this.dbDataAdapterService.saveAndPostEvent(toUpdate.toDto());
        return DataAdapterApi.fromDto(saved);
    }

    @POST
    @Path(value="adapters/validate")
    @NoAuditEvent(value="Validation only")
    @ApiOperation(value="Validate the data adapter config")
    @RequiresPermissions(value={"lookuptables:read"})
    public ValidationResult validateAdapter(@ApiParam DataAdapterApi toValidate) {
        DataAdapterDto adapterDto;
        ValidationResult validation = new ValidationResult();
        this.validator.validate((Object)toValidate, new Class[0]).stream().forEach(v -> validation.addError(v.getPropertyPath().toString(), v.getMessage()));
        Optional<DataAdapterDto> dtoOptional = this.dbDataAdapterService.get(toValidate.name());
        if (dtoOptional.isPresent() && !(adapterDto = dtoOptional.get()).id().equals(toValidate.id())) {
            validation.addError("name", "The data adapter name is already in use.");
        }
        Optional<Multimap<String, String>> configValidations = toValidate.config().validate(this.lookupDataAdapterValidationContext);
        configValidations.ifPresent(validation::addAll);
        return validation;
    }

    @GET
    @Path(value="caches")
    @ApiOperation(value="List available caches")
    @RequiresPermissions(value={"lookuptables:read"})
    public CachesPage caches(@ApiParam(name="page") @QueryParam(value="page") @DefaultValue(value="1") int page, @ApiParam(name="per_page") @QueryParam(value="per_page") @DefaultValue(value="50") int perPage, @ApiParam(name="sort", value="The field to sort the result on", required=true, allowableValues="title,description,name,id") @DefaultValue(value="title") @QueryParam(value="sort") String sort, @ApiParam(name="order", value="The sort direction", allowableValues="asc, desc") @DefaultValue(value="desc") @QueryParam(value="order") String order, @ApiParam(name="query") @QueryParam(value="query") String query) {
        if (!CACHE_ALLOWABLE_SORT_FIELDS.contains((Object)sort.toLowerCase(Locale.ENGLISH))) {
            sort = "title";
        }
        DBSort.SortBuilder sortBuilder = "desc".equalsIgnoreCase(order) ? DBSort.desc((String)sort) : DBSort.asc((String)sort);
        try {
            SearchQuery searchQuery = this.cacheSearchQueryParser.parse(query);
            DBQuery.Query dbQuery = searchQuery.toDBQuery();
            PaginatedList<CacheDto> paginated = this.dbCacheService.findPaginated(dbQuery, sortBuilder, page, perPage);
            return new CachesPage(query, paginated.pagination(), paginated.stream().map(CacheApi::fromDto).collect(Collectors.toList()));
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(e.getMessage(), (Throwable)e);
        }
    }

    @GET
    @Path(value="types/caches")
    @ApiOperation(value="List available caches types")
    @RequiresPermissions(value={"lookuptables:read"})
    public Map<String, LookupCache.Descriptor> availableCacheTypes() {
        return this.cacheTypes.values().stream().map(LookupCache.Factory::getDescriptor).collect(Collectors.toMap(LookupCache.Descriptor::getType, Function.identity()));
    }

    @GET
    @Path(value="caches/{idOrName}")
    @ApiOperation(value="List the given cache")
    public CacheApi getCache(@ApiParam(name="idOrName") @PathParam(value="idOrName") @NotEmpty String idOrName) {
        Optional<CacheDto> cacheDto = this.dbCacheService.get(idOrName);
        if (cacheDto.isPresent()) {
            this.checkPermission("lookuptables:read", cacheDto.get().id());
            return CacheApi.fromDto(cacheDto.get());
        }
        throw new NotFoundException();
    }

    @POST
    @Path(value="caches")
    @AuditEvent(type="server:lut_cache:create")
    @ApiOperation(value="Create a new cache")
    @RequiresPermissions(value={"lookuptables:create"})
    public CacheApi createCache(@ApiParam CacheApi newCache) {
        try {
            CacheDto saved = this.dbCacheService.saveAndPostEvent(newCache.toDto());
            return CacheApi.fromDto(saved);
        }
        catch (DuplicateKeyException e) {
            throw new BadRequestException(e.getMessage());
        }
    }

    @DELETE
    @Path(value="caches/{idOrName}")
    @AuditEvent(type="server:lut_cache:delete")
    @ApiOperation(value="Delete the given cache", notes="The cache cannot be in use by any lookup table, otherwise the request will fail.")
    public CacheApi deleteCache(@ApiParam(name="idOrName") @PathParam(value="idOrName") @NotEmpty String idOrName) {
        Optional<CacheDto> cacheDto = this.dbCacheService.get(idOrName);
        if (!cacheDto.isPresent()) {
            throw new NotFoundException();
        }
        CacheDto dto = cacheDto.get();
        this.checkPermission("lookuptables:delete", dto.id());
        boolean unused = this.dbTableService.findByCacheIds(Collections.singleton(dto.id())).isEmpty();
        if (!unused) {
            throw new BadRequestException("The cache is still in use, cannot delete.");
        }
        this.dbCacheService.deleteAndPostEvent(idOrName);
        return CacheApi.fromDto(dto);
    }

    @PUT
    @Path(value="caches/{idOrName}")
    @AuditEvent(type="server:lut_cache:update")
    @ApiOperation(value="Update the given cache settings")
    public CacheApi updateCache(@ApiParam(name="idOrName") @PathParam(value="idOrName") @NotEmpty String idOrName, @ApiParam CacheApi toUpdate) {
        this.checkLookupCacheId(idOrName, toUpdate);
        this.checkPermission("lookuptables:edit", toUpdate.id());
        CacheDto saved = this.dbCacheService.saveAndPostEvent(toUpdate.toDto());
        return CacheApi.fromDto(saved);
    }

    @POST
    @Path(value="caches/validate")
    @NoAuditEvent(value="Validation only")
    @ApiOperation(value="Validate the cache config")
    @RequiresPermissions(value={"lookuptables:read"})
    public ValidationResult validateCache(@ApiParam CacheApi toValidate) {
        CacheDto cacheDto;
        ValidationResult validation = new ValidationResult();
        this.validator.validate((Object)toValidate, new Class[0]).stream().forEach(v -> validation.addError(v.getPropertyPath().toString(), v.getMessage()));
        Optional<CacheDto> dtoOptional = this.dbCacheService.get(toValidate.name());
        if (dtoOptional.isPresent() && !(cacheDto = dtoOptional.get()).id().equals(toValidate.id())) {
            validation.addError("name", "The cache name is already in use.");
        }
        Optional<Multimap<String, String>> configValidations = toValidate.config().validate();
        configValidations.ifPresent(validation::addAll);
        return validation;
    }

    @JsonAutoDetect
    public static class LookupTablePage {
        @Nullable
        @JsonProperty
        private final String query;
        @JsonUnwrapped
        private final PaginatedList.PaginationInfo paginationInfo;
        @JsonProperty(value="lookup_tables")
        private final List<LookupTableApi> lookupTables;
        @JsonProperty(value="caches")
        private final Map<String, CacheApi> cacheApiMap;
        @JsonProperty(value="data_adapters")
        private final Map<String, DataAdapterApi> dataAdapterMap;

        public LookupTablePage(@Nullable String query, PaginatedList.PaginationInfo paginationInfo, List<LookupTableApi> lookupTables, Collection<CacheApi> caches, Collection<DataAdapterApi> dataAdapters) {
            this.query = query;
            this.paginationInfo = paginationInfo;
            this.lookupTables = lookupTables;
            this.cacheApiMap = Maps.uniqueIndex(caches, CacheApi::id);
            this.dataAdapterMap = Maps.uniqueIndex(dataAdapters, DataAdapterApi::id);
        }
    }

    @JsonAutoDetect
    public static class DataAdapterPage {
        @Nullable
        @JsonProperty
        private final String query;
        @JsonUnwrapped
        private final PaginatedList.PaginationInfo paginationInfo;
        @JsonProperty(value="data_adapters")
        private final List<DataAdapterApi> dataAdapters;

        public DataAdapterPage(@Nullable String query, PaginatedList.PaginationInfo paginationInfo, List<DataAdapterApi> dataAdapters) {
            this.query = query;
            this.paginationInfo = paginationInfo;
            this.dataAdapters = dataAdapters;
        }
    }

    @JsonAutoDetect
    public static class CachesPage {
        @Nullable
        @JsonProperty
        private final String query;
        @JsonUnwrapped
        private final PaginatedList.PaginationInfo paginationInfo;
        @JsonProperty(value="caches")
        private final List<CacheApi> caches;

        public CachesPage(@Nullable String query, PaginatedList.PaginationInfo paginationInfo, List<CacheApi> caches) {
            this.query = query;
            this.paginationInfo = paginationInfo;
            this.caches = caches;
        }
    }
}

