/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.tools;

import com.codahale.metrics.annotation.Timed;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.plugin.Tools;
import org.graylog2.rest.models.tools.requests.SubstringTestRequest;
import org.graylog2.rest.models.tools.responses.SubstringTesterResponse;
import org.graylog2.shared.rest.resources.RestResource;

@RequiresAuthentication
@Path(value="/tools/substring_tester")
public class SubstringTesterResource
extends RestResource {
    @GET
    @Timed
    @Produces(value={"application/json"})
    public SubstringTesterResponse substringTester(@QueryParam(value="begin_index") @Min(value=0L) @Min(value=0L) int beginIndex, @QueryParam(value="end_index") @Min(value=1L) @Min(value=1L) int endIndex, @QueryParam(value="string") @NotNull String string) {
        return this.doSubstringTest(string, beginIndex, endIndex);
    }

    @POST
    @Timed
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @NoAuditEvent(value="only used for testing substring extractor")
    public SubstringTesterResponse testSubstring(@Valid @NotNull SubstringTestRequest substringTestRequest) {
        return this.doSubstringTest(substringTestRequest.string(), substringTestRequest.start(), substringTestRequest.end());
    }

    private SubstringTesterResponse doSubstringTest(String string, int beginIndex, int endIndex) {
        String cut = Tools.safeSubstring(string, beginIndex, endIndex);
        return SubstringTesterResponse.create(cut != null, cut, beginIndex, endIndex);
    }
}

