/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.commons.collections;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.lang3.Validate;

public interface DirectedGraph<T>
extends Set<T> {
    public Node<T> get(T var1);

    public Set<Node<T>> nodeSet();

    public void add(T var1, T var2);

    public void add(T var1, Stream<T> var2);

    public void addEdge(T var1, T var2);

    public boolean removeEdge(T var1, T var2);

    public boolean edgeExists(T var1, T var2);

    public Stream<T> edgesFrom(T var1);

    public Set<T> getEdgesFrom(T var1);

    public static interface Node<T> {
        public static <T extends Comparable<? super T>> Comparator<Node<T>> comparingByValue() {
            return (Comparator & Serializable)(c1, c2) -> ((Comparable)c1.getValue()).compareTo(c2.getValue());
        }

        public static <T> Comparator<Node<T>> comparingByValue(Comparator<? super T> cmp) {
            Validate.notNull(cmp, (String)"invalid null comparator", (Object[])new Object[0]);
            return (Comparator & Serializable)(c1, c2) -> cmp.compare((Object)c1.getValue(), (Object)c2.getValue());
        }

        public T getValue();

        public boolean edgeExists(T var1);

        public Set<Node<T>> getEdges();

        public Stream<Node<T>> edges();

        public void add(T var1);

        public void add(Stream<T> var1);

        public void addEdge(T var1);

        public boolean removeEdge(T var1);

        public int hashCode();

        public boolean equals(Object var1);
    }
}

