/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.commons.collections;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.helenus.commons.collections.DirectedGraph;
import org.helenus.commons.collections.graph.ConcurrentHashDirectedGraph;
import org.helenus.commons.lang3.IllegalCycleException;

public class GraphUtils {
    private static <T> void explore(DirectedGraph.Node<T> node, DirectedGraph<T> rg, LinkedList<T> order, Set<T> visited, Set<T> expanding, boolean reverse, Function<T, ?> omapper, Function<T, String> smapper) {
        T v = node.getValue();
        if (!visited.add(v)) {
            if (expanding.contains(v)) {
                T t;
                LinkedList<T> cycle = new LinkedList<T>();
                Iterator<T> i = expanding.iterator();
                while (!(t = i.next()).equals(v)) {
                }
                cycle.addFirst(t);
                while (i.hasNext()) {
                    cycle.addFirst(i.next());
                }
                cycle.addFirst(v);
                List<T> ocycle = omapper != null ? cycle.stream().map(omapper).collect(Collectors.toList()) : cycle;
                if (smapper == null) {
                    throw new IllegalCycleException("cycle detected", ocycle);
                }
                throw new IllegalCycleException("cycle detected" + cycle.stream().map(smapper).collect(Collectors.joining(" -> ", ": ", "")), ocycle);
            }
            return;
        }
        expanding.add(v);
        node.edges().forEach(e -> GraphUtils.explore(e, rg, order, visited, expanding, reverse, omapper, smapper));
        if (reverse) {
            order.addFirst(v);
        } else {
            order.add(v);
        }
        expanding.remove(v);
    }

    private static <T> List<T> sort(DirectedGraph<T> g, boolean reverse, Function<T, ?> omapper, Function<T, String> smapper) {
        DirectedGraph rg = GraphUtils.reverse(g);
        int ssize = Math.max(8, rg.size() * 3 / 2);
        LinkedList order = new LinkedList();
        HashSet visited = new HashSet(ssize);
        LinkedHashSet expanding = new LinkedHashSet(ssize);
        rg.nodeSet().forEach(n -> GraphUtils.explore(n, rg, order, visited, expanding, reverse, omapper, smapper));
        return order;
    }

    public static <T> List<T> reverseSort(DirectedGraph<T> g) {
        return GraphUtils.sort(g, true, null, null);
    }

    public static <T> List<T> reverseSort(DirectedGraph<T> g, Function<T, String> smapper) {
        return GraphUtils.sort(g, true, null, smapper);
    }

    public static <T> List<T> reverseSort(DirectedGraph<T> g, Function<T, ?> omapper, Function<T, String> smapper) {
        return GraphUtils.sort(g, true, omapper, smapper);
    }

    public static <T> List<T> sort(DirectedGraph<T> g) {
        return GraphUtils.sort(g, false, null, null);
    }

    public static <T> List<T> sort(DirectedGraph<T> g, Function<T, String> smapper) {
        return GraphUtils.sort(g, false, null, smapper);
    }

    public static <T> List<T> sort(DirectedGraph<T> g, Function<T, ?> omapper, Function<T, String> smapper) {
        return GraphUtils.sort(g, false, omapper, smapper);
    }

    public static <T> DirectedGraph<T> reverse(DirectedGraph<T> g) {
        ConcurrentHashDirectedGraph result = new ConcurrentHashDirectedGraph(g.size());
        result.addAll(g);
        g.nodeSet().forEach(n -> n.edges().forEach(e -> result.addEdge(e.getValue(), n.getValue())));
        return result;
    }

    private GraphUtils() {
    }
}

