/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.commons.collections.graph;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.Validate;
import org.helenus.commons.collections.DirectedGraph;

public class ConcurrentHashDirectedGraph<T>
implements DirectedGraph<T>,
Cloneable,
Serializable {
    private static final long serialVersionUID = -8430194904167408569L;
    private final float loadFactor;
    private final int initialCapacity;
    private final Map<T, HashNode> graph;
    private transient Set<DirectedGraph.Node<T>> nodeSet = null;

    public ConcurrentHashDirectedGraph() {
        this(16, 0.75f);
    }

    public ConcurrentHashDirectedGraph(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public ConcurrentHashDirectedGraph(int initialCapacity, float loadFactor) {
        this.loadFactor = loadFactor;
        this.initialCapacity = initialCapacity;
        this.graph = new ConcurrentHashMap<T, HashNode>(initialCapacity, loadFactor);
    }

    @Override
    public int size() {
        return this.graph.size();
    }

    @Override
    public boolean isEmpty() {
        return this.graph.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.graph.containsKey(o);
    }

    @Override
    public Iterator<T> iterator() {
        final Iterator<Map.Entry<T, HashNode>> i = this.graph.entrySet().iterator();
        return new Iterator<T>(){
            Map.Entry<T, HashNode> current = null;

            @Override
            public boolean hasNext() {
                return i.hasNext();
            }

            @Override
            public T next() {
                this.current = (Map.Entry)i.next();
                return this.current.getKey();
            }

            @Override
            public void remove() {
                Validate.validState((this.current != null ? 1 : 0) != 0);
                i.remove();
                ConcurrentHashDirectedGraph.this.graph.values().stream().forEach(n -> ((HashNode)n).edges.remove(this.current));
                this.current = null;
            }
        };
    }

    @Override
    public Stream<T> stream() {
        return this.graph.keySet().stream();
    }

    @Override
    public Stream<T> parallelStream() {
        return this.graph.keySet().parallelStream();
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        this.graph.keySet().forEach(action);
    }

    @Override
    public Object[] toArray() {
        return this.graph.keySet().toArray();
    }

    @Override
    public <A> A[] toArray(A[] a) {
        return this.graph.keySet().toArray(a);
    }

    @Override
    public DirectedGraph.Node<T> get(T val) {
        return this.graph.get(val);
    }

    @Override
    public boolean add(T e) {
        return this.graph.putIfAbsent(e, new HashNode(e)) == null;
    }

    @Override
    public boolean remove(Object o) {
        HashNode node = this.graph.remove(o);
        if (node != null) {
            this.graph.values().stream().forEach(n -> ((HashNode)n).edges.remove(node));
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.graph.keySet().containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean added = false;
        for (T e : c) {
            if (!this.add(e)) continue;
            added = true;
        }
        return added;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean removed = false;
        Iterator<T> i = this.iterator();
        while (i.hasNext()) {
            if (c.contains(i.next())) continue;
            i.remove();
            removed = true;
        }
        return removed;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean removed = false;
        Iterator<Map.Entry<T, HashNode>> i = this.graph.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<T, HashNode> e = i.next();
            if (c.contains(e.getKey())) {
                i.remove();
                removed = true;
                continue;
            }
            Iterator j = e.getValue().edges.iterator();
            while (j.hasNext()) {
                if (!c.contains(((HashNode)j.next()).getValue())) continue;
                j.remove();
                removed = true;
            }
        }
        return removed;
    }

    @Override
    public void clear() {
        this.graph.clear();
    }

    @Override
    public Set<DirectedGraph.Node<T>> nodeSet() {
        NodeSet ns = this.nodeSet;
        return ns == null ? (this.nodeSet = new NodeSet()) : ns;
    }

    @Override
    public void add(T start, T dest) {
        HashNode sn = new HashNode(start);
        HashNode old = this.graph.putIfAbsent(start, sn);
        if (old != null) {
            sn = old;
        }
        sn.add(dest);
    }

    @Override
    public void add(T start, Stream<T> dests) {
        HashNode sn = new HashNode(start);
        HashNode old = this.graph.putIfAbsent(start, sn);
        if (old != null) {
            sn = old;
        }
        sn.add(dests);
    }

    @Override
    public void addEdge(T start, T dest) {
        HashNode sn = this.graph.get(start);
        if (sn == null) {
            throw new NoSuchElementException("unknown starting node");
        }
        sn.addEdge(dest);
    }

    @Override
    public boolean removeEdge(T start, T dest) {
        HashNode sn = this.graph.get(start);
        if (sn == null) {
            throw new NoSuchElementException("unknown starting node");
        }
        return sn.removeEdge(dest);
    }

    @Override
    public boolean edgeExists(T start, T dest) {
        HashNode sn = this.graph.get(start);
        if (sn == null) {
            throw new NoSuchElementException("unknown starting node");
        }
        return sn.edgeExists(dest);
    }

    @Override
    public Stream<T> edgesFrom(T node) {
        HashNode n = this.graph.get(node);
        if (n == null) {
            throw new NoSuchElementException("unknown node");
        }
        return n.edges().map(e -> e.getValue());
    }

    @Override
    public Set<T> getEdgesFrom(T node) {
        HashNode n = this.graph.get(node);
        if (n == null) {
            throw new NoSuchElementException("unknown node");
        }
        return Collections.unmodifiableSet(n.getEdges().stream().map(e -> e.getValue()).collect(Collectors.toSet()));
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public Object clone() {
        ConcurrentHashDirectedGraph<T> clone = new ConcurrentHashDirectedGraph<T>(this.initialCapacity, this.loadFactor);
        clone.addAll((Collection<T>)this.graph.keySet());
        clone.nodeSet().forEach(n -> this.graph.get(n.getValue()).edges().forEach(e -> n.addEdge(e.getValue())));
        return clone;
    }

    public String toString() {
        return this.graph.values().stream().map(n -> n.edges().map(e -> e.getValue() == this ? "(this graph)" : String.valueOf(e.getValue())).collect(Collectors.joining("-", n.getValue() == this ? "(this graph)" : String.valueOf(n.getValue()) + '=', ""))).collect(Collectors.joining(", ", "{", "}"));
    }

    private final class NodeSet
    extends AbstractSet<DirectedGraph.Node<T>> {
        private NodeSet() {
        }

        @Override
        public final int size() {
            return ConcurrentHashDirectedGraph.this.graph.size();
        }

        @Override
        public final void clear() {
            ConcurrentHashDirectedGraph.this.clear();
        }

        @Override
        public final Iterator<DirectedGraph.Node<T>> iterator() {
            final Iterator i = ConcurrentHashDirectedGraph.this.graph.entrySet().iterator();
            return new Iterator<DirectedGraph.Node<T>>(){
                Map.Entry<T, HashNode> current = null;

                @Override
                public boolean hasNext() {
                    return i.hasNext();
                }

                @Override
                public DirectedGraph.Node<T> next() {
                    this.current = (Map.Entry)i.next();
                    return this.current.getValue();
                }

                @Override
                public void remove() {
                    Validate.validState((this.current != null ? 1 : 0) != 0);
                    i.remove();
                    ConcurrentHashDirectedGraph.this.graph.values().stream().forEach(n -> ((HashNode)n).edges.remove(this.current));
                    this.current = null;
                }
            };
        }

        @Override
        public final boolean contains(Object o) {
            if (!(o instanceof DirectedGraph.Node)) {
                return false;
            }
            return this.contains(((DirectedGraph.Node)o).getValue());
        }

        @Override
        public final boolean remove(Object o) {
            if (o instanceof DirectedGraph.Node) {
                return this.remove(((DirectedGraph.Node)o).getValue());
            }
            return false;
        }

        @Override
        public final Spliterator<DirectedGraph.Node<T>> spliterator() {
            return ConcurrentHashDirectedGraph.this.graph.values().spliterator();
        }

        @Override
        public final void forEach(Consumer<? super DirectedGraph.Node<T>> action) {
            ConcurrentHashDirectedGraph.this.graph.values().forEach(action);
        }
    }

    private class HashNode
    implements DirectedGraph.Node<T>,
    Cloneable,
    Serializable {
        private static final long serialVersionUID = 2377326682367937940L;
        private final T value;
        private final HashSet<HashNode> edges;

        HashNode(T value) {
            this.edges = new HashSet(Math.min(ConcurrentHashDirectedGraph.this.initialCapacity / 16, 8), ConcurrentHashDirectedGraph.this.loadFactor);
            this.value = value;
        }

        @Override
        public T getValue() {
            return this.value;
        }

        @Override
        public boolean edgeExists(T dest) {
            HashNode node = (HashNode)ConcurrentHashDirectedGraph.this.graph.get(dest);
            if (node == null) {
                throw new NoSuchElementException("unknown destination node");
            }
            return this.edges.contains(node);
        }

        @Override
        public Set<DirectedGraph.Node<T>> getEdges() {
            return Collections.unmodifiableSet(this.edges);
        }

        @Override
        public Stream<DirectedGraph.Node<T>> edges() {
            return this.edges.stream().map(n -> n);
        }

        @Override
        public void add(T dest) {
            HashNode node = new HashNode(dest);
            HashNode old = ConcurrentHashDirectedGraph.this.graph.putIfAbsent(dest, node);
            if (old != null) {
                node = old;
            }
            this.edges.add(node);
        }

        @Override
        public void add(Stream<T> dests) {
            dests.forEach(d -> this.add(d));
        }

        @Override
        public void addEdge(T dest) {
            HashNode node = (HashNode)ConcurrentHashDirectedGraph.this.graph.get(dest);
            if (node == null) {
                throw new NoSuchElementException("unknown destination node");
            }
            this.edges.add(node);
        }

        @Override
        public boolean removeEdge(T dest) {
            HashNode node = (HashNode)ConcurrentHashDirectedGraph.this.graph.get(dest);
            if (node == null) {
                throw new NoSuchElementException("unknown destination node");
            }
            return this.edges.remove(node);
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.value);
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this;
        }

        public String toString() {
            return this.edges.stream().map(e -> String.valueOf(e.getValue())).collect(Collectors.joining("-", this.value + "=", ""));
        }
    }
}

