/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.commons.collections.iterators;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.collections4.ResettableIterator;
import org.apache.commons.lang3.Validate;

public class CombinationIterator<T>
implements Iterator<List<T>>,
ResettableIterator<List<T>> {
    private final Class<T> clazz;
    private final Collection<T>[] items;
    private final int size;
    private volatile boolean hasNext;
    private volatile boolean finished;
    private volatile Iterator<T>[] iterators;
    private volatile T[] current;

    @SafeVarargs
    public CombinationIterator(Class<T> clazz, Collection<T> ... items) {
        Validate.notNull(clazz, (String)"invalid null class", (Object[])new Object[0]);
        Validate.notNull(items, (String)"invalid null items", (Object[])new Object[0]);
        Validate.isTrue((items.length > 0 ? 1 : 0) != 0, (String)"no collection of items provided", (Object[])new Object[0]);
        this.clazz = clazz;
        this.items = items;
        this.size = items.length;
        this.hasNext = false;
        this.finished = false;
        this.iterators = null;
        this.current = null;
    }

    public CombinationIterator(Class<T> clazz, Collection<Collection<T>> items) {
        Validate.notNull(clazz, (String)"invalid null class", (Object[])new Object[0]);
        Validate.notNull(items, (String)"invalid null items", (Object[])new Object[0]);
        Validate.isTrue((!items.isEmpty() ? 1 : 0) != 0, (String)"no collection of items provided", (Object[])new Object[0]);
        this.clazz = clazz;
        this.items = items.toArray(new Collection[items.size()]);
        this.size = items.size();
        this.hasNext = false;
        this.finished = false;
        this.iterators = null;
        this.current = null;
    }

    public int size() {
        int size = this.items[0].size();
        for (int i = 1; i < this.items.length; ++i) {
            i *= this.items[i].size();
        }
        return size;
    }

    @Override
    public boolean hasNext() {
        if (this.hasNext) {
            return true;
        }
        if (this.finished) {
            return false;
        }
        if (this.iterators == null) {
            this.iterators = new Iterator[this.size];
            this.current = (Object[])Array.newInstance(this.clazz, this.size);
            for (int j = 0; j < this.size; ++j) {
                Iterator<T> i = this.items[j].iterator();
                this.iterators[j] = i;
                if (!i.hasNext()) {
                    this.finished = true;
                    this.current = null;
                    this.iterators = null;
                    return false;
                }
                this.current[j] = i.next();
            }
            this.hasNext = true;
            return true;
        }
        if (this.current == null) {
            this.current = (Object[])Array.newInstance(this.clazz, this.size);
        }
        for (int j = this.size - 1; j >= 0; --j) {
            Iterator<T> i = this.iterators[j];
            if (i.hasNext()) {
                this.current[j] = i.next();
                this.hasNext = true;
                return true;
            }
            if (i instanceof ResettableIterator) {
                ((ResettableIterator)i).reset();
            } else {
                i = this.items[j].iterator();
            }
            if (!i.hasNext()) break;
            this.current[j] = i.next();
            this.iterators[j] = i;
        }
        this.finished = true;
        this.current = null;
        this.iterators = null;
        return false;
    }

    @Override
    public List<T> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("CombinationIterator");
        }
        this.hasNext = false;
        return Arrays.asList(this.current);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("CombinationIterator");
    }

    public void reset() {
        this.hasNext = false;
        this.finished = false;
        this.iterators = null;
        this.current = null;
    }
}

